/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class MethodLateBoundReferencesSearcher
implements QueryExecutor<PsiReference, MethodReferencesSearch.SearchParameters> {
    public boolean execute(final MethodReferencesSearch.SearchParameters params, Processor<PsiReference> consumer) {
        PsiMethod element = params.getMethod();
        if (element instanceof PsiMethod) {
            Project project;
            String name;
            final PsiMethod method = element;
            SearchScope searchScope = PsiUtil.restrictScopeToGroovyFiles(new Computable<SearchScope>(){

                public SearchScope compute() {
                    return params.getScope().intersectWith(MethodLateBoundReferencesSearcher.this.getUseScopeInReadAction(method));
                }
            });
            if (!this.processTextOccurrences(searchScope, name = method.getName(), consumer, project = element.getProject())) {
                return false;
            }
            String propName = this.getPropertyName(method);
            if (propName != null && !this.processTextOccurrences(searchScope, propName, consumer, project)) {
                return false;
            }
        }
        return true;
    }

    private SearchScope getUseScopeInReadAction(final PsiMethod method) {
        return (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return method.getUseScope();
            }
        });
    }

    private String getPropertyName(final PsiMethod method) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return PropertyUtil.getPropertyName((PsiMethod)method);
            }
        });
    }

    private boolean processTextOccurrences(SearchScope searchScope, final String name, final Processor<PsiReference> consumer, Project project) {
        TextOccurenceProcessor processor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                PsiReference ref = element.getReference();
                return !(element instanceof GrReferenceExpression) || !name.equals(((GrReferenceExpression)element).getReferenceName()) || ref == null || ref.resolve() != null || PsiUtil.isLValue((GroovyPsiElement)element) || consumer.process((Object)((PsiReference)element));
            }
        };
        return PsiManager.getInstance((Project)project).getSearchHelper().processElementsWithWord(processor, searchScope, name, (short)1, true);
    }
}

