/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;

@State(name="GroovyCompilerConfiguration", storages={@Storage(id="default", file="$WORKSPACE_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/groovyc.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class GroovyCompilerConfiguration
implements PersistentStateComponent<MyStateBean>,
Disposable {
    private String myHeapSize = "400";
    private boolean myUseGroovycStubs = false;
    public boolean transformsOk = false;
    private final ExcludedEntriesConfiguration myExcludeFromStubGeneration = new ExcludedEntriesConfiguration();

    public MyStateBean getState() {
        MyStateBean bean = new MyStateBean();
        bean.heapSize = this.myHeapSize;
        bean.useGroovycStubs = this.myUseGroovycStubs;
        bean.transformsOk = this.transformsOk;
        this.myExcludeFromStubGeneration.writeExternal(bean.excludes);
        return bean;
    }

    public static ExcludedEntriesConfiguration getExcludeConfiguration(Project project) {
        return GroovyCompilerConfiguration.getInstance((Project)project).myExcludeFromStubGeneration;
    }

    public ExcludedEntriesConfiguration getExcludeFromStubGeneration() {
        return this.myExcludeFromStubGeneration;
    }

    public void loadState(MyStateBean state) {
        this.myHeapSize = state.heapSize;
        this.myUseGroovycStubs = state.useGroovycStubs;
        this.transformsOk = state.transformsOk;
        this.myExcludeFromStubGeneration.readExternal(state.excludes);
    }

    public static GroovyCompilerConfiguration getInstance(Project project) {
        return (GroovyCompilerConfiguration)ServiceManager.getService((Project)project, GroovyCompilerConfiguration.class);
    }

    public String getHeapSize() {
        return this.myHeapSize;
    }

    public void setHeapSize(String heapSize) {
        this.myHeapSize = heapSize;
    }

    public boolean isUseGroovycStubs() {
        return this.myUseGroovycStubs;
    }

    public void setUseGroovycStubs(boolean useGroovycStubs) {
        this.myUseGroovycStubs = useGroovycStubs;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myExcludeFromStubGeneration);
    }

    public static class MyStateBean {
        public String heapSize = "400";
        @Tag(value="excludes")
        public Element excludes = new Element("aaa");
        public boolean useGroovycStubs = false;
        public boolean transformsOk = false;
    }
}

