/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;

public class GroovySwitchStatementWithNoDefaultInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovySwitchStatementWithNoDefaultInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Switch statement with no default case" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovySwitchStatementWithNoDefaultInspection.getDisplayName must not return null");
        }
        return "Switch statement with no default case";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref statement with no default branch#loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(GrSwitchStatement switchStatement) {
            GrCaseSection[] caseSections;
            super.visitSwitchStatement(switchStatement);
            for (GrCaseSection caseSection : caseSections = switchStatement.getCaseSections()) {
                if (!caseSection.getCaseLabel().getText().startsWith("default")) continue;
                return;
            }
            this.registerError(switchStatement.getFirstChild());
        }
    }
}

