/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GroovyLoopStatementThatDoesntLoopInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyLoopStatementThatDoesntLoopInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Loop statement that doesn't loop" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyLoopStatementThatDoesntLoopInspection.getDisplayName must not return null");
        }
        return "Loop statement that doesn't loop";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "<code>#ref</code> statement doesn't loop #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitForStatement(GrForStatement forStatement) {
            super.visitForStatement(forStatement);
            GrStatement body = forStatement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget(forStatement)) {
                return;
            }
            this.registerStatementError(forStatement, new Object[0]);
        }

        @Override
        public void visitWhileStatement(GrWhileStatement whileStatement) {
            super.visitWhileStatement(whileStatement);
            GrStatement body = whileStatement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget(whileStatement)) {
                return;
            }
            this.registerStatementError(whileStatement, new Object[0]);
        }
    }
}

