/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.AddNoInspectionGroovyCommentFix;
import org.jetbrains.plugins.groovy.codeInspection.SuppressForMemberFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovySuppressableInspectionTool
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    @Nullable
    public SuppressIntentionAction[] getSuppressActions(PsiElement element) {
        HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)this.getShortName());
        return new SuppressIntentionAction[]{new AddNoInspectionGroovyCommentFix(displayKey), new SuppressForMemberFix(displayKey, false), new SuppressForMemberFix(displayKey, true)};
    }

    public boolean isSuppressedFor(PsiElement element) {
        return GroovySuppressableInspectionTool.getElementToolSuppressedIn(element, this.getID()) != null;
    }

    @Nullable
    private static PsiElement getElementToolSuppressedIn(final PsiElement place, final String toolId) {
        if (place == null) {
            return null;
        }
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

            @Nullable
            public PsiElement compute() {
                PsiElement statement = PsiUtil.findEnclosingStatement(place);
                if (statement != null) {
                    String text;
                    Matcher matcher;
                    PsiElement prev;
                    for (prev = statement.getPrevSibling(); prev != null && StringUtil.isEmpty((String)prev.getText().trim()); prev = prev.getPrevSibling()) {
                    }
                    if (prev instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                        return prev;
                    }
                }
                GrMember member = (GrMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{GrMember.class});
                while (member != null) {
                    GrModifierList modifierList = member.getModifierList();
                    for (String ids : GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation(modifierList)) {
                        if (!SuppressionUtil.isInspectionToolIdMentioned((String)ids, (String)toolId)) continue;
                        return modifierList;
                    }
                    member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)member, GrMember.class);
                }
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Collection<String> getInspectionIdsSuppressedInAnnotation(GrModifierList modifierList) {
        List<String> list;
        if (modifierList == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation must not return null");
            return list;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        if (annotation == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation must not return null");
            return list;
        }
        GrAnnotationMemberValue attributeValue = (GrAnnotationMemberValue)annotation.findAttributeValue(null);
        ArrayList<String> result = new ArrayList<String>();
        if (attributeValue instanceof GrListOrMap) {
            for (GrExpression annotationMemberValue : ((GrListOrMap)attributeValue).getInitializers()) {
                String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(annotationMemberValue);
                if (id == null) continue;
                result.add(id);
            }
        } else {
            String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(attributeValue);
            if (id != null) {
                result.add(id);
            }
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation must not return null");
    }

    @Nullable
    private static String getInspectionIdSuppressedInAnnotationAttribute(GrAnnotationMemberValue element) {
        Object value;
        if (element instanceof GrLiteral && (value = ((GrLiteral)element).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }
}

