/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.CompositeCompletionData;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeInspection.local.GroovyUnusedImportsPassFactory;
import org.jetbrains.plugins.groovy.debugger.GroovyPositionManager;
import org.jetbrains.plugins.groovy.extensions.completion.InsertHandlerRegistry;
import org.jetbrains.plugins.groovy.lang.GroovyChangeUtilSupport;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData;
import org.jetbrains.plugins.groovy.lang.editor.actions.GroovyEditorActionsManager;
import org.jetbrains.plugins.groovy.lang.groovydoc.completion.GroovyDocCompletionData;
import org.jetbrains.plugins.groovy.lang.groovydoc.completion.handlers.GroovyDocMethodHandler;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyLoader
implements ApplicationComponent {
    public void initComponent() {
        GroovyEditorActionsManager.registerGroovyEditorActions();
        ChangeUtil.registerCopyHandler((TreeCopyHandler)new GroovyChangeUtilSupport());
        GroovyLoader.setupCompletion();
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project) {
                TextEditorHighlightingPassRegistrar registrar = TextEditorHighlightingPassRegistrar.getInstance((Project)project);
                GroovyUnusedImportsPassFactory unusedImportsPassFactory = (GroovyUnusedImportsPassFactory)((Object)project.getComponent(GroovyUnusedImportsPassFactory.class));
                registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)unusedImportsPassFactory, new int[]{4}, null, true, -1);
                DebuggerManager.getInstance((Project)project).registerPositionManagerFactory((Function)new Function<DebugProcess, PositionManager>(){

                    public PositionManager fun(DebugProcess debugProcess) {
                        return new GroovyPositionManager(debugProcess);
                    }
                });
            }
        });
        GroovyLoader.registerNameValidators();
    }

    private static void registerNameValidators() {
        RenameInputValidator validator = new RenameInputValidator(){

            public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
                return !GroovyRefactoringUtil.KEYWORDS.contains(newName);
            }
        };
        RenameInputValidatorRegistry.getInstance().registerInputValidator((ElementPattern)PlatformPatterns.psiElement(GrNamedElement.class), validator);
    }

    private static void setupCompletion() {
        InsertHandlerRegistry handlerRegistry = InsertHandlerRegistry.getInstance();
        handlerRegistry.registerSpecificInsertHandler(new GroovyDocMethodHandler());
        CompositeCompletionData compositeCompletionData = new CompositeCompletionData(new GroovyCompletionData(), new GroovyDocCompletionData());
        CompletionUtil.registerCompletionData((FileType)GroovyFileType.GROOVY_FILE_TYPE, (CompletionData)compositeCompletionData);
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("groovy.support.loader" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/GroovyLoader.getComponentName must not return null");
        }
        return "groovy.support.loader";
    }
}

