/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.highlighter.GroovyEditorHighlighter;

public class GroovyFileType
extends LanguageFileType {
    public static final GroovyFileType GROOVY_FILE_TYPE = new GroovyFileType();
    public static final Language GROOVY_LANGUAGE = GROOVY_FILE_TYPE.getLanguage();
    @NonNls
    public static final String DEFAULT_EXTENSION = "groovy";

    private GroovyFileType() {
        super((Language)new GroovyLanguage());
    }

    @NotNull
    @NonNls
    public String getName() {
        if ("Groovy" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/GroovyFileType.getName must not return null");
        }
        return "Groovy";
    }

    @NonNls
    @NotNull
    public String getDescription() {
        if ("Groovy Files" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/GroovyFileType.getDescription must not return null");
        }
        return "Groovy Files";
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/GroovyFileType.getDefaultExtension must not return null");
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return GroovyIcons.GROOVY_ICON_16x16;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    public EditorHighlighter getEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/GroovyFileType.getEditorHighlighter must not be null");
        }
        return new GroovyEditorHighlighter(colors, project, virtualFile);
    }
}

