/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.ExtensionPoints;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginConverter;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;

public class ExtensionDomExtender
extends DomExtender<Extensions> {
    private static final PsiClassConverter CLASS_CONVERTER = new PluginPsiClassConverter();

    public void registerExtensions(@NotNull Extensions extensions, @NotNull DomExtensionsRegistrar registrar) {
        if (extensions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender.registerExtensions must not be null");
        }
        if (registrar == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender.registerExtensions must not be null");
        }
        XmlElement xmlElement = extensions.getXmlElement();
        if (xmlElement == null) {
            return;
        }
        PsiManager psiManager = xmlElement.getManager();
        IdeaPlugin ideaPlugin = (IdeaPlugin)extensions.getParentOfType(IdeaPlugin.class, true);
        if (ideaPlugin == null) {
            return;
        }
        String prefix = extensions.getDefaultExtensionNs().getStringValue();
        if (prefix == null) {
            prefix = extensions.getXmlns().getStringValue();
        }
        prefix = prefix != null ? prefix + "." : "";
        ExtensionDomExtender.registerExtensions(prefix, ideaPlugin, registrar, psiManager);
        Collection<String> dependencies = ExtensionDomExtender.getDependencies(ideaPlugin);
        for (IdeaPlugin plugin : IdeaPluginConverter.collectAllVisiblePlugins(DomUtil.getFile((DomElement)extensions))) {
            String value = plugin.getPluginId();
            if (value == null || !dependencies.contains(value)) continue;
            ExtensionDomExtender.registerExtensions(prefix, plugin, registrar, psiManager);
        }
    }

    private static void registerExtensions(String prefix, IdeaPlugin plugin, DomExtensionsRegistrar registrar, PsiManager psiManager) {
        String pluginId = plugin.getPluginId();
        for (ExtensionPoints points : plugin.getExtensionPoints()) {
            for (ExtensionPoint point : points.getExtensionPoints()) {
                ExtensionDomExtender.registerExtensionPoint(registrar, point, psiManager, prefix, pluginId);
            }
        }
    }

    private static void registerExtensionPoint(DomExtensionsRegistrar registrar, final ExtensionPoint extensionPoint, final PsiManager manager, String prefix, @Nullable String pluginId) {
        String epName = extensionPoint.getName().getStringValue();
        if (epName != null && StringUtil.isNotEmpty((String)pluginId)) {
            epName = pluginId + "." + epName;
        }
        if (epName == null) {
            epName = extensionPoint.getQualifiedName().getStringValue();
        }
        if (epName == null) {
            return;
        }
        if (!epName.startsWith(prefix)) {
            return;
        }
        DomExtension domExtension = registrar.registerCollectionChildrenExtension(new XmlName(epName.substring(prefix.length())), Extension.class);
        domExtension.putUserData(DomExtension.KEY_DECLARATION, (Object)extensionPoint);
        domExtension.addExtender(new DomExtender(){

            public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                if (domElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$1.registerExtensions must not be null");
                }
                if (registrar == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$1.registerExtensions must not be null");
                }
                String interfaceName = extensionPoint.getInterface().getStringValue();
                if (interfaceName != null) {
                    registrar.registerGenericAttributeValueChildExtension(new XmlName("implementation"), PsiClass.class).setConverter((Converter)CLASS_CONVERTER);
                    PsiClass implClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(interfaceName, GlobalSearchScope.allScope((Project)manager.getProject()));
                    if (implClass != null) {
                        ExtensionDomExtender.registerXmlb(registrar, implClass);
                    }
                } else {
                    PsiClass beanClass;
                    String beanClassName = extensionPoint.getBeanClass().getStringValue();
                    if (beanClassName != null && (beanClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(beanClassName, GlobalSearchScope.allScope((Project)manager.getProject()))) != null) {
                        ExtensionDomExtender.registerXmlb(registrar, beanClass);
                    }
                }
            }
        });
    }

    private static void registerXmlb(DomExtensionsRegistrar registrar, PsiClass beanClass) {
        PsiField[] fields;
        for (PsiField field : fields = beanClass.getAllFields()) {
            if (!field.hasModifierProperty("public")) continue;
            ExtensionDomExtender.registerField(registrar, field);
        }
    }

    private static void registerField(DomExtensionsRegistrar registrar, @NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender.registerField must not be null");
        }
        PsiAnnotation[] annotations = field.getModifierList().getAnnotations();
        PsiConstantEvaluationHelper evalHelper = JavaPsiFacade.getInstance((Project)field.getProject()).getConstantEvaluationHelper();
        for (PsiAnnotation annotation : annotations) {
            PsiExpression expression;
            Object evaluatedExpression;
            PsiAnnotationMemberValue attributeName;
            String qName = annotation.getQualifiedName();
            if (qName == null) continue;
            if (qName.equals(Attribute.class.getName())) {
                attributeName = annotation.findAttributeValue("value");
                if (attributeName == null || !(attributeName instanceof PsiExpression)) continue;
                Class<String> type = String.class;
                PsiExpression expression2 = (PsiExpression)attributeName;
                Object evaluatedExpression2 = evalHelper.computeConstantExpression((PsiElement)expression2, false);
                if (evaluatedExpression2 == null) continue;
                registrar.registerGenericAttributeValueChildExtension(new XmlName(evaluatedExpression2.toString()), type);
                continue;
            }
            if (!qName.equals(Tag.class.getName()) || (attributeName = annotation.findAttributeValue("value")) == null || !(attributeName instanceof PsiExpression) || (evaluatedExpression = evalHelper.computeConstantExpression((PsiElement)(expression = (PsiExpression)attributeName), false)) == null) continue;
            registrar.registerFixedNumberChildExtension(new XmlName(evaluatedExpression.toString()), SimpleTagValue.class);
        }
    }

    public static Collection<String> getDependencies(IdeaPlugin ideaPlugin) {
        PsiFile psiFile;
        VirtualFile mainPluginXml;
        String fileName;
        VirtualFile file;
        HashSet<String> result = new HashSet<String>();
        result.add("com.intellij");
        for (Dependency dependency : ideaPlugin.getDependencies()) {
            ContainerUtil.addIfNotNull((Object)dependency.getStringValue(), result);
        }
        if (ideaPlugin.getPluginId() == null && (file = DomUtil.getFile((DomElement)ideaPlugin).getOriginalFile().getVirtualFile()) != null && !"plugin.xml".equals(fileName = file.getName()) && (mainPluginXml = file.findFileByRelativePath("../plugin.xml")) != null && (psiFile = PsiManager.getInstance((Project)ideaPlugin.getManager().getProject()).findFile(mainPluginXml)) instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            DomFileElement fileElement = ideaPlugin.getManager().getFileElement(xmlFile, IdeaPlugin.class);
            if (fileElement != null) {
                IdeaPlugin mainPlugin = (IdeaPlugin)fileElement.getRootElement();
                ContainerUtil.addIfNotNull((Object)mainPlugin.getPluginId(), result);
                for (Dependency dependency : mainPlugin.getDependencies()) {
                    ContainerUtil.addIfNotNull((Object)dependency.getStringValue(), result);
                }
            }
        }
        return result;
    }

    static interface SimpleTagValue
    extends DomElement {
        @TagValue
        public String getValue();
    }
}

