/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.AbstractSvnUpdateIntegrateEnvironment;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler;
import org.jetbrains.idea.svn.update.MergeRootInfo;
import org.jetbrains.idea.svn.update.SvnIntegratePanel;
import org.jetbrains.idea.svn.update.SvnUpdateConfigurable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnIntegrateEnvironment
extends AbstractSvnUpdateIntegrateEnvironment {
    public SvnIntegrateEnvironment(SvnVcs vcs) {
        super(vcs);
    }

    @Override
    protected AbstractUpdateIntegrateCrawler createCrawler(ISVNEventHandler eventHandler, boolean totalUpdate, ArrayList<VcsException> exceptions, UpdatedFiles updatedFiles) {
        return new IntegrateCrawler(this.myVcs, eventHandler, totalUpdate, exceptions, updatedFiles);
    }

    @Override
    public Configurable createConfigurable(final Collection<FilePath> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return new SvnUpdateConfigurable(this.myVcs.getProject()){

            @Override
            protected AbstractSvnUpdatePanel createPanel() {
                return new SvnIntegratePanel(SvnIntegrateEnvironment.this.myVcs, collection);
            }

            public String getDisplayName() {
                return SvnBundle.message("integrate.display.name", new Object[0]);
            }

            @Override
            public String getHelpTopic() {
                return "reference.dialogs.versionControl.integrate.project.subversion";
            }
        };
    }

    @Override
    protected boolean isDryRun() {
        return SvnConfiguration.getInstanceChecked((Project)this.myVcs.getProject()).MERGE_DRY_RUN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getLastMergedRevision(SVNRevision rev2, SVNURL svnURL2) {
        if (!rev2.isValid() || rev2.isLocal()) {
            return null;
        }
        long number = rev2.getNumber();
        if (number > 0L) {
            return String.valueOf(number);
        }
        SVNRepository repos = null;
        try {
            repos = this.myVcs.createRepository(svnURL2.toString());
            long latestRev = repos.getLatestRevision();
            String string = String.valueOf(latestRev);
            return string;
        }
        catch (SVNException e) {
            String string = null;
            return string;
        }
        finally {
            if (repos != null) {
                repos.closeSession();
            }
        }
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    private class IntegrateCrawler
    extends AbstractUpdateIntegrateCrawler {
        public IntegrateCrawler(SvnVcs vcs, ISVNEventHandler handler, boolean totalUpdate, Collection<VcsException> exceptions, UpdatedFiles postUpdateFiles) {
            super(totalUpdate, postUpdateFiles, exceptions, handler, vcs);
        }

        @Override
        protected void showProgressMessage(ProgressIndicator progress, File root) {
            if (SvnConfiguration.getInstanceChecked((Project)this.myVcs.getProject()).MERGE_DRY_RUN) {
                progress.setText(SvnBundle.message("progress.text.merging.dry.run.changes", root.getAbsolutePath()));
            } else {
                progress.setText(SvnBundle.message("progress.text.merging.changes", root.getAbsolutePath()));
            }
        }

        @Override
        protected long doUpdate(File root, SVNUpdateClient client) throws SVNException {
            SvnConfiguration svnConfig = SvnConfiguration.getInstanceChecked(this.myVcs.getProject());
            MergeRootInfo info = svnConfig.getMergeRootInfo(root, this.myVcs);
            if (info.getUrlString1().equals(info.getUrlString2()) && info.getRevision1().equals((Object)info.getRevision2())) {
                return 0L;
            }
            SVNDiffClient diffClient = this.myVcs.createDiffClient();
            diffClient.setEventHandler(this.myHandler);
            diffClient.doMerge(info.getUrl1(), info.getRevision1(), info.getUrl2(), info.getRevision2(), root, svnConfig.UPDATE_DEPTH, svnConfig.MERGE_DIFF_USE_ANCESTRY, false, svnConfig.MERGE_DRY_RUN, false);
            svnConfig.LAST_MERGED_REVISION = SvnIntegrateEnvironment.this.getLastMergedRevision(info.getRevision2(), info.getUrl2());
            return info.getResultRevision();
        }

        @Override
        protected boolean isMerge() {
            return true;
        }
    }
}

