/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DiffContentRevision
implements ContentRevision {
    private String myPath;
    private SVNRepository myRepository;
    private String myContents;
    private FilePath myFilePath;
    private long myRevision;

    public DiffContentRevision(String path, @NotNull SVNRepository repos, long revision) {
        if (repos == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/status/DiffContentRevision.<init> must not be null");
        }
        this(path, repos, revision, VcsUtil.getFilePath((String)path));
    }

    public DiffContentRevision(String path, SVNRepository repository, long revision, FilePath filePath) {
        this.myPath = path;
        this.myRepository = repository;
        this.myFilePath = filePath;
        this.myRevision = revision;
    }

    @Nullable
    public String getContent() throws VcsException {
        if (this.myContents == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            try {
                this.myRepository.getFile(this.myPath, -1L, null, (OutputStream)bos);
                this.myRepository.closeSession();
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            this.myContents = new String(bos.toByteArray());
        }
        return this.myContents;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/status/DiffContentRevision.getFile must not return null");
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber.Long longVal = new VcsRevisionNumber.Long(this.myRevision);
        if (longVal == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/status/DiffContentRevision.getRevisionNumber must not return null");
        }
        return longVal;
    }
}

