/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.SelectFilesDialog;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class MarkResolvedAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.name.mark.resolved", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return false;
    }

    @Override
    protected boolean isEnabled(Project project, @NotNull SvnVcs vcs, VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/actions/MarkResolvedAction.isEnabled must not be null");
        }
        if (file.isDirectory()) {
            return SvnStatusUtil.isUnderControl(project, file);
        }
        FileStatus fStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        return FileStatus.MERGED_WITH_CONFLICTS.equals(fStatus) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(fStatus) || FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(fStatus);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.batchPerform(project, activeVcs, new VirtualFile[]{file}, context);
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
        SvnVcs vcs = SvnVcs.getInstance(project);
        ApplicationManager.getApplication().saveAll();
        Collection<String> paths = MarkResolvedAction.collectResolvablePaths(vcs, files);
        if (paths.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)SvnBundle.message("message.text.no.conflicts.found", new Object[0]), (String)SvnBundle.message("message.title.no.conflicts.found", new Object[0]));
            return;
        }
        String[] pathsArray = ArrayUtil.toStringArray(paths);
        SelectFilesDialog dialog = new SelectFilesDialog(project, SvnBundle.message("label.select.files.and.directories.to.mark.resolved", new Object[0]), SvnBundle.message("dialog.title.mark.resolved", new Object[0]), SvnBundle.message("action.name.mark.resolved", new Object[0]), pathsArray, "vcs.subversion.resolve");
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        pathsArray = dialog.getSelectedPaths();
        try {
            SVNWCClient wcClient = vcs.createWCClient();
            for (String path : pathsArray) {
                File ioFile = new File(path);
                wcClient.doResolve(ioFile, false);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        finally {
            for (VirtualFile file : files) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                file.refresh(true, false);
                if (file.getParent() == null) continue;
                file.getParent().refresh(true, false);
            }
        }
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    private static Collection<String> collectResolvablePaths(SvnVcs vcs, VirtualFile[] files) {
        final TreeSet<String> target = new TreeSet<String>();
        SVNStatusClient stClient = vcs.createStatusClient();
        for (VirtualFile file : files) {
            try {
                stClient.doStatus(new File(file.getPath()), true, false, false, false, new ISVNStatusHandler(){

                    public void handleStatus(SVNStatus status) {
                        if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == SVNStatusType.STATUS_CONFLICTED) {
                            target.add(status.getFile().getAbsolutePath());
                        }
                    }
                });
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        return target;
    }
}

