/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SVNFileUtil.getAdminDirectoryName();
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String DIR_PROPS_FILE_NAME = "dir-props";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    @NonNls
    public static final String LOCK_FILE_NAME = "lock";

    private SvnUtil() {
    }

    public static void crawlWCRoots(VirtualFile path, NotNullFunction<VirtualFile, Collection<VirtualFile>> callback) {
        block5: {
            boolean isDirectory;
            block4: {
                VirtualFile parentVFile;
                if (path == null) {
                    return;
                }
                isDirectory = path.isDirectory();
                VirtualFile virtualFile = parentVFile = !isDirectory || !path.exists() ? path.getParent() : path;
                if (parentVFile == null) {
                    return;
                }
                File parent = new File(parentVFile.getPath());
                if (!SVNWCUtil.isVersionedDirectory((File)parent)) break block4;
                SvnUtil.checkCanceled();
                Collection pending = (Collection)callback.fun((Object)path);
                SvnUtil.checkCanceled();
                for (VirtualFile virtualFile2 : pending) {
                    SvnUtil.crawlWCRoots(virtualFile2, callback);
                }
                break block5;
            }
            if (!isDirectory) break block5;
            SvnUtil.checkCanceled();
            VirtualFile[] children = path.getChildren();
            for (int i = 0; children != null && i < children.length; ++i) {
                SvnUtil.checkCanceled();
                VirtualFile child = children[i];
                if (!child.isDirectory()) continue;
                SvnUtil.crawlWCRoots(child, callback);
            }
        }
    }

    public static Collection<File> crawlWCRoots(File path, SvnWCRootCrawler callback, ProgressIndicator progress) {
        File parent;
        HashSet<File> result = new HashSet<File>();
        File file = parent = path.isFile() || !path.exists() ? path.getParentFile() : path;
        if (SVNWCUtil.isVersionedDirectory((File)parent)) {
            SvnUtil.checkCanceled(progress);
            Collection<File> pending = callback.handleWorkingCopyRoot(path, progress);
            SvnUtil.checkCanceled(progress);
            for (File aPending : pending) {
                result.addAll(SvnUtil.crawlWCRoots(aPending, callback, progress));
            }
            result.add(path);
        } else if (path.isDirectory()) {
            SvnUtil.checkCanceled(progress);
            File[] children = path.listFiles();
            for (int i = 0; children != null && i < children.length; ++i) {
                SvnUtil.checkCanceled(progress);
                File child = children[i];
                if (!child.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(child, callback, progress));
            }
        }
        return result;
    }

    private static void checkCanceled() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        SvnUtil.checkCanceled(indicator);
    }

    private static void checkCanceled(ProgressIndicator progress) {
        if (progress != null && progress.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    public static String[] getLocationsForModule(SvnVcs vcs, File path, ProgressIndicator progress) {
        LocationsCrawler crawler = new LocationsCrawler(vcs);
        SvnUtil.crawlWCRoots(path, crawler, progress);
        return crawler.getLocations();
    }

    public static Map<String, File> getLocationInfoForModule(SvnVcs vcs, File path, ProgressIndicator progress) {
        LocationsCrawler crawler = new LocationsCrawler(vcs);
        SvnUtil.crawlWCRoots(path, crawler, progress);
        return crawler.getLocationInfos();
    }

    public static void doLockFiles(Project project, final SvnVcs activeVcs, final File[] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        if (activeVcs.getCheckoutOptions().getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles != null && ioFiles.length > 1);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        final SVNException[] exception = new SVNException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ISVNEventHandler eventHandler = new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) {
                if (event.getAction() == SVNEventAction.LOCK_FAILED) {
                    failedLocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    SVNWCClient wcClient = activeVcs.createWCClient();
                    wcClient.setEventHandler(eventHandler);
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        File file = ioFile;
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", file.getName()));
                        }
                        wcClient.doLock(new File[]{file}, force, lockMessage);
                    }
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.lock.failures", new Object[0]));
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    public static void doUnlockFiles(Project project, final SvnVcs activeVcs, final File[] ioFiles) throws VcsException {
        boolean force = true;
        final SVNException[] exception = new SVNException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ISVNEventHandler eventHandler = new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) {
                if (event.getAction() == SVNEventAction.UNLOCK_FAILED) {
                    failedUnlocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    SVNWCClient wcClient = activeVcs.createWCClient();
                    wcClient.setEventHandler(eventHandler);
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        File file = ioFile;
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", file.getName()));
                        }
                        wcClient.doUnlock(new File[]{file}, true);
                    }
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    public static String formatRepresentation(WorkingCopyFormat format) {
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version16.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_FIVE.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version15.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_FOUR.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version14.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_THREE.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version13.text", new Object[0]);
        }
        return "";
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        SVNWCClient client = vcs.createWCClient();
        try {
            SVNInfo info = client.doInfo(file, SVNRevision.WORKING);
            return info == null ? null : info.getRepositoryUUID();
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, SVNURL url) {
        SVNWCClient client = vcs.createWCClient();
        try {
            SVNInfo info = client.doInfo(url, SVNRevision.WORKING, SVNRevision.WORKING);
            return info == null ? null : info.getRepositoryUUID();
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, File file) {
        SVNWCClient client = vcs.createWCClient();
        try {
            SVNInfo info = client.doInfo(file, SVNRevision.WORKING);
            return info == null ? null : info.getRepositoryRootURL();
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SVNURL.parseURIEncoded((String)url));
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, SVNURL url) {
        SVNWCClient client = vcs.createWCClient();
        try {
            SVNInfo info = client.doInfo(url, SVNRevision.UNDEFINED, SVNRevision.HEAD);
            return info == null ? null : info.getRepositoryRootURL();
        }
        catch (SVNException e) {
            return null;
        }
    }

    public static boolean isWorkingCopyRoot(File file) {
        try {
            return SVNWCUtil.isWorkingCopyRoot((File)file);
        }
        catch (SVNException e) {
            return false;
        }
    }

    @Nullable
    public static File getWorkingCopyRoot(File inFile) {
        File file;
        for (file = inFile; file != null && (file.isFile() || !file.exists()); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        try {
            return SVNWCUtil.getWorkingCopyRoot((File)file, (boolean)true);
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getWorkingCopyUrl(SvnVcs vcs, File file) {
        try {
            if (SVNWCUtil.isWorkingCopyRoot((File)file)) {
                SVNWCClient client = vcs.createWCClient();
                SVNInfo info = client.doInfo(file, SVNRevision.WORKING);
                return info.getURL();
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return null;
    }

    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) throws SVNException {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return new File(baseDir, part);
    }

    public static VirtualFile getVirtualFile(String filePath) {
        final String path = VfsUtil.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(path);
            }
        });
    }

    @Nullable
    public static SVNURL getBranchForUrl(SvnVcs vcs, VirtualFile vcsRoot, String urlPath) {
        try {
            SVNURL url = SVNURL.parseURIEncoded((String)urlPath);
            SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
            return configuration == null ? null : configuration.getWorkingBranch(url);
        }
        catch (SVNException e) {
            return null;
        }
        catch (VcsException e1) {
            return null;
        }
    }

    @Nullable
    public static String getPathForProgress(SVNEvent event) {
        if (event.getFile() != null) {
            return event.getFile().getName();
        }
        if (event.getURL() != null) {
            return event.getURL().toString();
        }
        return null;
    }

    @Nullable
    public static VirtualFile correctRoot(Project project, String path) {
        if (path.length() == 0) {
            return project.getBaseDir();
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    public static VirtualFile correctRoot(Project project, VirtualFile file) {
        if (file.getPath().length() == 0) {
            return project.getBaseDir();
        }
        return file;
    }

    public static boolean isOneDotFiveAvailable(Project project, RepositoryLocation location) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        List<WCInfo> infos = vcs.getAllWcInfos();
        for (WCInfo info : infos) {
            if (!info.getFormat().supportsMergeInfo()) continue;
            String url = info.getUrl().toString();
            if (location != null && !location.toPresentableString().startsWith(url) && !url.startsWith(location.toPresentableString()) || !SvnUtil.checkRepositoryVersion15(vcs, url)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkRepositoryVersion15(SvnVcs vcs, String url) {
        SVNRepository repository = null;
        try {
            repository = vcs.createRepository(url);
            boolean bl = repository.hasCapability(SVNCapability.MERGE_INFO);
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    public static SVNStatus getStatus(SvnVcs vcs, File file) {
        SVNStatusClient statusClient = vcs.createStatusClient();
        try {
            return statusClient.doStatus(file, false);
        }
        catch (SVNException e) {
            return null;
        }
    }

    public static SVNDepth getDepth(SvnVcs vcs, File file) {
        SVNWCClient client = vcs.createWCClient();
        try {
            SVNInfo svnInfo = client.doInfo(file, SVNRevision.WORKING);
            if (svnInfo != null) {
                return svnInfo.getDepth();
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return SVNDepth.UNKNOWN;
    }

    public static boolean seemsLikeVersionedDir(VirtualFile file) {
        VirtualFile[] children;
        String adminName = SVNFileUtil.getAdminDirectoryName();
        for (VirtualFile child : children = file.getChildren()) {
            if (!adminName.equals(child.getName()) || !child.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(File parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParentFile()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SVNURL getUrl(File file) {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            wcAccess.probeOpen(file, false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(file, false);
            SVNURL sVNURL = entry.getSVNURL();
            return sVNURL;
        }
        catch (SVNException e) {
        }
        finally {
            try {
                wcAccess.close();
            }
            catch (SVNException e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesRepositorySupportMergeinfo(SvnVcs vcs, SVNURL url) {
        SVNRepository repository = null;
        try {
            repository = vcs.createRepository(url);
            boolean bl = repository.hasCapability(SVNCapability.MERGE_INFO);
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    private static class LocationsCrawler
    implements SvnWCRootCrawler {
        private final SvnVcs myVcs;
        private final Map<String, File> myLocations;

        public LocationsCrawler(SvnVcs vcs) {
            this.myVcs = vcs;
            this.myLocations = new HashMap<String, File>();
        }

        public String[] getLocations() {
            Set<String> set = this.myLocations.keySet();
            return ArrayUtil.toStringArray(set);
        }

        public Map<String, File> getLocationInfos() {
            return Collections.unmodifiableMap(this.myLocations);
        }

        @Override
        public Collection<File> handleWorkingCopyRoot(File root, ProgressIndicator progress) {
            HashSet<File> result = new HashSet<File>();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.discovering.location", root.getAbsolutePath()));
            }
            try {
                SVNWCClient wcClient = this.myVcs.createWCClient();
                SVNInfo info = wcClient.doInfo(root, SVNRevision.WORKING);
                if (info != null && info.getURL() != null) {
                    this.myLocations.put(info.getURL().toString(), info.getFile());
                }
            }
            catch (SVNException e) {
                // empty catch block
            }
            return result;
        }
    }
}

