/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.StringLenComparator;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ForNestedRootChecker;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.NestedCopiesData;
import org.jetbrains.idea.svn.NestedCopiesSink;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Real;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnCompatibilityChecker;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnCopyRootSimple;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnMapping;
import org.jetbrains.idea.svn.SvnMappingSavedPart;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ThreadLocalDefendedInvoker;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

@State(name="SvnFileUrlMappingImpl", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
class SvnFileUrlMappingImpl
implements SvnFileUrlMapping,
PersistentStateComponent<SvnMappingSavedPart>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnFileUrlMappingImpl");
    private final SvnCompatibilityChecker myChecker;
    private final Object myMonitor = new Object();
    private final SvnMapping myMapping;
    private final SvnMapping myMoreRealMapping;
    private final MyRootsHelper myHelper;
    private final Project myProject;
    private final NestedCopiesSink myTempSink;
    private boolean myInitialized;

    public static SvnFileUrlMappingImpl getInstance(Project project) {
        return (SvnFileUrlMappingImpl)project.getComponent(SvnFileUrlMappingImpl.class);
    }

    private SvnFileUrlMappingImpl(Project project, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myMapping = new SvnMapping();
        this.myMoreRealMapping = new SvnMapping();
        this.myHelper = new MyRootsHelper(vcsManager);
        this.myChecker = new SvnCompatibilityChecker(project);
        this.myTempSink = new NestedCopiesSink();
    }

    @Override
    @Nullable
    public SVNURL getUrlForFile(File file) {
        RootUrlInfo rootUrlInfo = this.getWcRootForFilePath(file);
        if (rootUrlInfo == null) {
            return null;
        }
        String absolutePath = file.getAbsolutePath();
        String rootAbsPath = rootUrlInfo.getIoFile().getAbsolutePath();
        if (absolutePath.length() < rootAbsPath.length()) {
            if (absolutePath.equals(rootAbsPath.substring(0, rootAbsPath.length() - 1))) {
                return rootUrlInfo.getAbsoluteUrlAsUrl();
            }
            return null;
        }
        String relativePath = absolutePath.substring(rootAbsPath.length());
        try {
            return rootUrlInfo.getAbsoluteUrlAsUrl().appendPath(FileUtil.toSystemIndependentName((String)relativePath), true);
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getLocalPath(String url) {
        Object object = this.myMonitor;
        synchronized (object) {
            String rootUrl = this.getUrlRootForUrl(url);
            if (rootUrl == null) {
                return null;
            }
            RootUrlInfo parentInfo = this.myMapping.byUrl(rootUrl);
            if (parentInfo == null) {
                return null;
            }
            return SvnFileUrlMappingImpl.fileByUrl(parentInfo.getIoFile().getAbsolutePath(), rootUrl, url).getAbsolutePath();
        }
    }

    public static File fileByUrl(String parentPath, String parentUrl, String childUrl) {
        return new File(parentPath, childUrl.substring(parentUrl.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForFilePath(File file) {
        Object object = this.myMonitor;
        synchronized (object) {
            String root = this.getRootForPath(file);
            if (root == null) {
                return null;
            }
            return this.myMapping.byFile(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rootsDiffer() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMapping.isRootsDifferFromSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForUrl(String url) {
        Object object = this.myMonitor;
        synchronized (object) {
            String rootUrl = this.getUrlRootForUrl(url);
            if (rootUrl == null) {
                return null;
            }
            RootUrlInfo result = this.myMapping.byUrl(rootUrl);
            if (result == null) {
                LOG.info("Inconsistent maps for url:" + url + " found root url: " + rootUrl);
                return null;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RootUrlInfo> getAllWcInfos() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMoreRealMapping.getAllCopies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> convertRoots(List<VirtualFile> result) {
        if (this.myHelper.isInside()) {
            return result;
        }
        Object object = this.myMonitor;
        synchronized (object) {
            List<VirtualFile> cachedRoots = this.myMapping.getUnderVcsRoots();
            List<VirtualFile> lonelyRoots = this.myMapping.getLonelyRoots();
            if (!lonelyRoots.isEmpty()) {
                this.myChecker.reportNoRoots(lonelyRoots);
            }
            if (cachedRoots.isEmpty()) {
                return result;
            }
            return cachedRoots;
        }
    }

    public void acceptNestedData(Set<NestedCopiesBuilder.MyPointInfo> set) {
        this.myTempSink.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init() {
        Object object = this.myMonitor;
        synchronized (object) {
            boolean result = this.myInitialized;
            this.myInitialized = true;
            return result;
        }
    }

    public void realRefresh(AtomicSectionsAware atomicSectionsAware) {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        VirtualFile[] roots = (VirtualFile[])this.myHelper.executeDefended();
        CopiesApplier copiesApplier = new CopiesApplier();
        CopiesDetector copiesDetector = new CopiesDetector(atomicSectionsAware, vcs, copiesApplier, (Getter)new Getter<NestedCopiesData>(){

            public NestedCopiesData get() {
                return (NestedCopiesData)SvnFileUrlMappingImpl.this.myTempSink.receive();
            }
        });
        copiesDetector.detectCopyRoots(roots, this.init());
    }

    private static SVNStatus getExternalItemStatus(SvnVcs vcs, final File file) {
        SVNStatusClient statusClient = vcs.createStatusClient();
        try {
            if (file.isDirectory()) {
                return statusClient.doStatus(file, false);
            }
            File parent = file.getParentFile();
            if (parent != null) {
                statusClient.setFilesProvider(new ISVNStatusFileProvider(){

                    public Map getChildrenFiles(File parent) {
                        return Collections.singletonMap(file.getAbsolutePath(), file);
                    }
                });
                final Ref refStatus = new Ref();
                statusClient.doStatus(parent, SVNRevision.WORKING, SVNDepth.FILES, false, true, false, false, new ISVNStatusHandler(){

                    public void handleStatus(SVNStatus status) throws SVNException {
                        if (file.equals(status.getFile())) {
                            refStatus.set((Object)status);
                        }
                    }
                }, null);
                return (SVNStatus)refStatus.get();
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public String getUrlRootForUrl(String currentUrl) {
        for (String url : this.myMapping.getUrls()) {
            if (!SVNPathUtil.isAncestor((String)url, (String)currentUrl)) continue;
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getRootForPath(File currentPath) {
        ArrayList<String> paths;
        String convertedPath = currentPath.getAbsolutePath();
        convertedPath = currentPath.isDirectory() && !convertedPath.endsWith(File.separator) ? convertedPath + File.separator : convertedPath;
        Object object = this.myMonitor;
        synchronized (object) {
            paths = new ArrayList<String>(this.myMapping.getFileRoots());
        }
        Collections.sort(paths, StringLenComparator.getDescendingInstance());
        for (String path : paths) {
            if (!FileUtil.startsWith((String)convertedPath, (String)path)) continue;
            return path;
        }
        return null;
    }

    @Override
    public VirtualFile[] getNotFilteredRoots() {
        return (VirtualFile[])this.myHelper.executeDefended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMapping.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMappingSavedPart getState() {
        SvnMappingSavedPart result = new SvnMappingSavedPart();
        SvnMapping mapping = new SvnMapping();
        SvnMapping realMapping = new SvnMapping();
        Object object = this.myMonitor;
        synchronized (object) {
            mapping.copyFrom(this.myMapping);
            realMapping.copyFrom(this.myMoreRealMapping);
        }
        for (RootUrlInfo info : mapping.getAllCopies()) {
            result.add(this.convert(info));
        }
        for (RootUrlInfo info : realMapping.getAllCopies()) {
            result.addReal(this.convert(info));
        }
        return result;
    }

    private SvnCopyRootSimple convert(RootUrlInfo info) {
        SvnCopyRootSimple copy = new SvnCopyRootSimple();
        copy.myVcsRoot = FileUtil.toSystemDependentName((String)info.getRoot().getPath());
        copy.myCopyRoot = info.getIoFile().getAbsolutePath();
        return copy;
    }

    public void loadState(final SvnMappingSavedPart state) {
        final SvnMapping mapping = new SvnMapping();
        final SvnMapping realMapping = new SvnMapping();
        ((ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject)).addInitializationRequest(VcsInitObject.AFTER_COMMON, (Runnable)new DumbAwareRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SvnFileUrlMappingImpl.this.fillMapping(mapping, state.getMappingRoots());
                    SvnFileUrlMappingImpl.this.fillMapping(realMapping, state.getMoreRealMappingRoots());
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    LOG.info(t);
                    return;
                }
                Object object = SvnFileUrlMappingImpl.this.myMonitor;
                synchronized (object) {
                    SvnFileUrlMappingImpl.this.myMapping.copyFrom(mapping);
                    SvnFileUrlMappingImpl.this.myMoreRealMapping.copyFrom(realMapping);
                }
            }
        });
    }

    private void fillMapping(SvnMapping mapping, List<SvnCopyRootSimple> list) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (SvnCopyRootSimple simple : list) {
            SvnVcs vcs;
            SVNInfo svnInfo;
            VirtualFile copyRoot = lfs.findFileByIoFile(new File(simple.myCopyRoot));
            VirtualFile vcsRoot = lfs.findFileByIoFile(new File(simple.myVcsRoot));
            if (copyRoot == null || vcsRoot == null || (svnInfo = (vcs = SvnVcs.getInstance(this.myProject)).getInfo(copyRoot)) == null || svnInfo.getRepositoryRootURL() == null) continue;
            RootUrlInfo info = new RootUrlInfo(svnInfo.getRepositoryRootURL(), svnInfo.getURL(), SvnFormatSelector.getWorkingCopyFormat(svnInfo.getFile()), copyRoot, vcsRoot);
            mapping.add(info);
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("SvnFileUrlMappingImpl" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnFileUrlMappingImpl.getComponentName must not return null");
        }
        return "SvnFileUrlMappingImpl";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class RepoInfo {
        private final SVNURL myUrl;
        private final boolean myRepoSupportsMergeinfo;

        private RepoInfo(SVNURL url, boolean repoSupportsMergeinfo) {
            this.myRepoSupportsMergeinfo = repoSupportsMergeinfo;
            this.myUrl = url;
        }

        public boolean isRepoSupportsMergeinfo() {
            return this.myRepoSupportsMergeinfo;
        }

        public SVNURL getUrl() {
            return this.myUrl;
        }
    }

    private static class RepositoryRoots {
        private final SvnVcs myVcs;
        private final Set<SVNURL> myRoots;

        private RepositoryRoots(SvnVcs vcs) {
            this.myVcs = vcs;
            this.myRoots = new HashSet<SVNURL>();
        }

        public void register(SVNURL url) {
            this.myRoots.add(url);
        }

        public SVNURL ask(SVNURL url) {
            for (SVNURL root : this.myRoots) {
                if (!root.equals((Object)SVNURLUtil.getCommonURLAncestor((SVNURL)root, (SVNURL)url))) continue;
                return root;
            }
            SVNURL newUrl = SvnUtil.getRepositoryRoot(this.myVcs, url);
            if (newUrl != null) {
                this.myRoots.add(newUrl);
                return newUrl;
            }
            return null;
        }
    }

    private static class CopiesDetector {
        private final AtomicSectionsAware myAtomicSectionsAware;
        private final SvnVcs myVcs;
        private final CopiesApplier myApplier;
        private final List<VirtualFile> myLonelyRoots;
        private final List<RootUrlInfo> myTopRoots;
        private final RepositoryRoots myRepositoryRoots;
        private final Getter<NestedCopiesData> myGate;

        private CopiesDetector(AtomicSectionsAware atomicSectionsAware, SvnVcs vcs, CopiesApplier applier, Getter<NestedCopiesData> gate) {
            this.myAtomicSectionsAware = atomicSectionsAware;
            this.myVcs = vcs;
            this.myApplier = applier;
            this.myGate = gate;
            this.myTopRoots = new ArrayList<RootUrlInfo>();
            this.myLonelyRoots = new ArrayList<VirtualFile>();
            this.myRepositoryRoots = new RepositoryRoots(this.myVcs);
        }

        public void detectCopyRoots(VirtualFile[] roots, boolean clearState) {
            Getter<Boolean> cancelGetter = new Getter<Boolean>(){

                public Boolean get() {
                    return CopiesDetector.this.myAtomicSectionsAware.shouldExitAsap();
                }
            };
            for (VirtualFile vcsRoot : roots) {
                List<Real> foundRoots = ForNestedRootChecker.getAllNestedWorkingCopies(vcsRoot, this.myVcs, false, cancelGetter);
                if (foundRoots.isEmpty()) {
                    this.myLonelyRoots.add(vcsRoot);
                }
                for (Real foundRoot : foundRoots) {
                    SVNURL repoRoot = foundRoot.getInfo().getRepositoryRootURL();
                    if (repoRoot == null) {
                        LOG.info("Error: cannot find repository URL for versioned folder: " + foundRoot.getFile().getPath());
                        continue;
                    }
                    this.myRepositoryRoots.register(repoRoot);
                    this.myTopRoots.add(new RootUrlInfo(repoRoot, foundRoot.getInfo().getURL(), SvnFormatSelector.getWorkingCopyFormat(foundRoot.getInfo().getFile()), foundRoot.getFile(), vcsRoot));
                }
            }
            if (!SvnConfiguration.getInstance((Project)this.myVcs.getProject()).DETECT_NESTED_COPIES) {
                this.myApplier.apply(this.myVcs, this.myAtomicSectionsAware, this.myTopRoots, this.myLonelyRoots);
            } else {
                this.addNestedRoots(clearState);
            }
        }

        private void addNestedRoots(final boolean clearState) {
            final List basicVfRoots = ObjectsConvertor.convert(this.myTopRoots, (Convertor)new Convertor<RootUrlInfo, VirtualFile>(){

                public VirtualFile convert(RootUrlInfo real) {
                    return real.getVirtualFile();
                }
            });
            ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
            if (clearState) {
                this.myGate.get();
            }
            clManager.invokeAfterUpdate(new Runnable(){

                @Override
                public void run() {
                    ArrayList<RootUrlInfo> nestedRoots = new ArrayList<RootUrlInfo>();
                    NestedCopiesData data = (NestedCopiesData)CopiesDetector.this.myGate.get();
                    block2: for (NestedCopiesBuilder.MyPointInfo info : data.getSet()) {
                        if (NestedCopyType.external.equals((Object)info.getType()) || NestedCopyType.switched.equals((Object)info.getType())) {
                            File infoFile = new File(info.getFile().getPath());
                            boolean copyFound = false;
                            for (RootUrlInfo topRoot : CopiesDetector.this.myTopRoots) {
                                if (!topRoot.getIoFile().equals(infoFile)) continue;
                                topRoot.setType(info.getType());
                                copyFound = true;
                                break;
                            }
                            if (copyFound) continue;
                            try {
                                SVNStatus svnStatus = SvnUtil.getStatus(CopiesDetector.this.myVcs, infoFile);
                                if (svnStatus.getURL() == null) continue;
                                info.setUrl(svnStatus.getURL());
                                info.setFormat(WorkingCopyFormat.getInstance(svnStatus.getWorkingCopyFormat()));
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        for (RootUrlInfo topRoot : CopiesDetector.this.myTopRoots) {
                            if (!VfsUtil.isAncestor((VirtualFile)topRoot.getVirtualFile(), (VirtualFile)info.getFile(), (boolean)true)) continue;
                            SVNURL repoRoot = CopiesDetector.this.myRepositoryRoots.ask(info.getUrl());
                            if (repoRoot == null) continue block2;
                            RootUrlInfo rootInfo = new RootUrlInfo(repoRoot, info.getUrl(), info.getFormat(), info.getFile(), topRoot.getRoot());
                            rootInfo.setType(info.getType());
                            nestedRoots.add(rootInfo);
                            continue block2;
                        }
                    }
                    CopiesDetector.this.myTopRoots.addAll(nestedRoots);
                    CopiesDetector.this.myApplier.apply(CopiesDetector.this.myVcs, CopiesDetector.this.myAtomicSectionsAware, CopiesDetector.this.myTopRoots, CopiesDetector.this.myLonelyRoots);
                }
            }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, null, (Consumer)new Consumer<VcsDirtyScopeManager>(){

                public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                    if (clearState) {
                        vcsDirtyScopeManager.filesDirty(null, (Collection)basicVfRoots);
                    }
                }
            }, null);
        }
    }

    private class CopiesApplier {
        private CopiesApplier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(SvnVcs vcs, AtomicSectionsAware atomicSectionsAware, List<RootUrlInfo> roots, List<VirtualFile> lonelyRoots) {
            SvnMapping mapping = new SvnMapping();
            mapping.addAll(roots);
            mapping.reportLonelyRoots(lonelyRoots);
            SvnMapping groupedMapping = new SvnMapping();
            ArrayList<RootUrlInfo> filtered = new ArrayList<RootUrlInfo>();
            ForNestedRootChecker.filterOutSuperfluousChildren(vcs, roots, filtered);
            groupedMapping.addAll(filtered);
            try {
                atomicSectionsAware.enter();
                Object object = SvnFileUrlMappingImpl.this.myMonitor;
                synchronized (object) {
                    SvnFileUrlMappingImpl.this.myMapping.copyFrom(mapping);
                    SvnFileUrlMappingImpl.this.myMoreRealMapping.copyFrom(groupedMapping);
                }
            }
            finally {
                atomicSectionsAware.exit();
            }
            ((Runnable)SvnFileUrlMappingImpl.this.myProject.getMessageBus().syncPublisher(SvnVcs.ROOTS_RELOADED)).run();
        }
    }

    private class MyRootsHelper
    extends ThreadLocalDefendedInvoker<VirtualFile[]> {
        private final ProjectLevelVcsManager myPlVcsManager;

        private MyRootsHelper(ProjectLevelVcsManager vcsManager) {
            this.myPlVcsManager = vcsManager;
        }

        @Override
        protected VirtualFile[] execute() {
            return this.myPlVcsManager.getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(SvnFileUrlMappingImpl.this.myProject));
        }
    }
}

