/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts;

import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;

public class CvsWizard
extends AbstractWizard<WizardStep> {
    protected CvsWizard(String title, Project project) {
        super(title, project);
    }

    protected void init() {
        super.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CvsWizard.this.updateStep();
            }
        });
    }

    protected String getHelpID() {
        return null;
    }

    protected void doNextAction() {
        if (this.myCurrentStep + 1 >= this.mySteps.size()) {
            return;
        }
        WizardStep nextStep = (WizardStep)((Object)this.mySteps.get(this.myCurrentStep + 1));
        if (!nextStep.preNextCheck()) {
            return;
        }
        super.doNextAction();
    }

    public void updateStep() {
        super.updateStep();
        if (this.getNumberOfSteps() == 0) {
            return;
        }
        WizardStep currentStep = (WizardStep)this.getCurrentStepObject();
        if (!currentStep.setActive()) {
            this.doPreviousAction();
            return;
        }
        currentStep.getPreferredFocusedComponent().requestFocus();
        if (!currentStep.nextIsEnabled()) {
            this.getNextButton().setEnabled(false);
            this.getFinishButton().setEnabled(false);
        } else {
            this.getFinishButton().setEnabled(this.getCurrentStep() + 1 == this.getNumberOfSteps());
        }
    }

    public void disableNextAndFinish() {
        if (this.getNextButton().isEnabled() || this.getFinishButton().isEnabled()) {
            this.updateStep();
        }
    }

    public void enableNextAndFinish() {
        if (!this.getNextButton().isEnabled() || !this.getFinishButton().isEnabled()) {
            this.updateStep();
        }
    }

    protected void doOKAction() {
        for (WizardStep step : this.mySteps) {
            step.saveState();
        }
        super.doOKAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            for (WizardStep step : this.mySteps) {
                step.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void goToPrevious() {
        this.doPreviousAction();
    }
}

