/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CreateFileObjects;
import com.intellij.cvsSupport2.cvsoperations.common.CvsCommandOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;

public abstract class CvsOperationOnFiles
extends CvsCommandOperation {
    protected Collection<File> myFiles = new ArrayList<File>();
    private Map<CvsRootProvider, ArrayList<File>> myRootsToFiles;

    public CvsOperationOnFiles(IAdminReader reader) {
        super(reader);
    }

    public CvsOperationOnFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(CvsExecutionEnvironment executionEnvironment) throws VcsException, CommandAbortedException {
        Class<CvsOperation> clazz = CvsOperation.class;
        synchronized (CvsOperation.class) {
            if (!this.myFiles.isEmpty()) {
                try {
                    super.execute(executionEnvironment);
                }
                finally {
                    this.clearCachedEntriesForProcessedFiles();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void clearCachedEntriesForProcessedFiles() {
        CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
        for (File myFile : this.myFiles) {
            File parentFile = myFile.getParentFile();
            if (parentFile == null) continue;
            try {
                VirtualFile vParent = CvsVfsUtil.findFileByPath(parentFile.getCanonicalPath().replace(File.separatorChar, '/'));
                if (vParent == null) continue;
                entriesManager.clearCachedEntriesFor(vParent);
            }
            catch (IOException error) {
                LOG.error((Throwable)error);
            }
        }
    }

    protected File[] getFilesAsArray(CvsRootProvider root) {
        try {
            Collection files = this.getRootsToFilesMap().get(root);
            return files.toArray(new File[files.size()]);
        }
        catch (CannotFindCvsRootException e) {
            LOG.error((Throwable)e);
            return new File[0];
        }
    }

    public boolean addFile(VirtualFile file) {
        return this.addFile(file == null ? "" : file.getPath());
    }

    public boolean addFile(File file) {
        this.myRootsToFiles = null;
        return this.addFile(file.getAbsolutePath());
    }

    public boolean addFiles(VirtualFile[] file) {
        for (VirtualFile aFile : file) {
            this.addFile(aFile);
        }
        return true;
    }

    public boolean addFile(String path) {
        return this.myFiles.add(new File(path));
    }

    public int getFilesCount() {
        return this.myFiles.size();
    }

    @Override
    public int getFilesToProcessCount() {
        return this.getFilesCount();
    }

    private Map<CvsRootProvider, ArrayList<File>> buildRootsToFilesMap() throws CannotFindCvsRootException {
        HashMap result = new HashMap();
        for (File file : this.myFiles) {
            CvsRootProvider cvsRoot = CvsRootProvider.createOn(file);
            if (cvsRoot == null) {
                throw new CannotFindCvsRootException(file);
            }
            if (!result.containsKey((Object)cvsRoot)) {
                result.put((Object)cvsRoot, new ArrayList());
            }
            ((ArrayList)result.get((Object)cvsRoot)).add(file);
        }
        return result;
    }

    protected Map<CvsRootProvider, ArrayList<File>> getRootsToFilesMap() throws CannotFindCvsRootException {
        if (this.myRootsToFiles == null) {
            this.myRootsToFiles = this.buildRootsToFilesMap();
        }
        return this.myRootsToFiles;
    }

    @Override
    protected Collection<CvsRootProvider> getAllCvsRoots() throws CannotFindCvsRootException {
        return this.getRootsToFilesMap().keySet();
    }

    protected void addFilesToCommand(CvsRootProvider root, AbstractCommand command) {
        CreateFileObjects createFileObjects = new CreateFileObjects(this.getLocalRootFor(root), this.getFilesAsArray(root));
        Collection<AbstractFileObject> fileObjects = createFileObjects.execute();
        for (AbstractFileObject fileObject : fileObjects) {
            command.getFileObjects().addFileObject(fileObject);
        }
    }
}

