/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProviderImpl;
import com.intellij.cvsSupport2.connections.ssh.ui.SshPasswordDialog;

public class SshConnectionUtil {
    private SshConnectionUtil() {
    }

    public static boolean promptForPassword(SshSettings settings, String cvsRoot) {
        if (!settings.USE_PPK) {
            SSHPasswordProviderImpl sshPasswordProvider = SSHPasswordProviderImpl.getInstance();
            String password = sshPasswordProvider.getPasswordForCvsRoot(cvsRoot);
            if (password == null) {
                SshPasswordDialog sshPasswordDialog = new SshPasswordDialog(CvsBundle.message((String)"propmt.text.enter.password.for", (Object[])new Object[]{cvsRoot}));
                sshPasswordDialog.show();
                if (!sshPasswordDialog.isOK()) {
                    return false;
                }
                password = sshPasswordDialog.getPassword();
                sshPasswordProvider.storePasswordForCvsRoot(cvsRoot, password, sshPasswordDialog.saveThisPassword());
            }
            if (password == null) {
                return false;
            }
        } else {
            SSHPasswordProviderImpl sshPasswordProvider = SSHPasswordProviderImpl.getInstance();
            String password = sshPasswordProvider.getPPKPasswordForCvsRoot(cvsRoot);
            if (password == null) {
                SshPasswordDialog sshPasswordDialog = new SshPasswordDialog(CvsBundle.message((String)"propmt.text.enter.private.key.password.for", (Object[])new Object[]{cvsRoot}));
                sshPasswordDialog.setAdditionalText(CvsBundle.message((String)"prompt.path.to.private.key", (Object[])new Object[]{settings.PATH_TO_PPK}));
                sshPasswordDialog.show();
                if (!sshPasswordDialog.isOK()) {
                    return false;
                }
                password = sshPasswordDialog.getPassword();
                sshPasswordProvider.storePPKPasswordForCvsRoot(cvsRoot, password, sshPasswordDialog.saveThisPassword());
            }
            if (password == null) {
                return false;
            }
        }
        return true;
    }
}

