/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsInfo;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.IDEARootFormatter;
import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfo;
import com.intellij.cvsSupport2.cvsIgnore.UserDirIgnores;
import com.intellij.cvsSupport2.cvsstatuses.CvsEntriesListener;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsEntriesManager
extends VirtualFileAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.application.CvsEntriesManager");
    private final Map<VirtualFile, CvsInfo> myInfoByParentDirectoryPath = new HashMap();
    private static final String CVS_ADMIN_DIRECTORY_NAME = "CVS";
    private final Collection<CvsEntriesListener> myEntriesListeners = new ArrayList<CvsEntriesListener>();
    private int myIsActive = 0;
    private final Collection<String> myFilesToRefresh = new HashSet();
    private int mySynchronizationActionLocks = 0;
    private final Map<String, CvsConnectionSettings> myStringToSettingsMap = new HashMap();
    private final UserDirIgnores myUserDirIgnores = new UserDirIgnores();
    private final MyVirtualFileManagerListener myVirtualFileManagerListener = new MyVirtualFileManagerListener();
    private final CvsApplicationLevelConfiguration myApplicationLevelConfiguration;

    public static CvsEntriesManager getInstance() {
        return (CvsEntriesManager)((Object)ServiceManager.getService(CvsEntriesManager.class));
    }

    public CvsEntriesManager(CvsApplicationLevelConfiguration applicationLevelConfiguration) {
        this.myApplicationLevelConfiguration = applicationLevelConfiguration;
    }

    public void registerAsVirtualFileListener() {
        if (this.myIsActive == 0) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
            VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)this.myVirtualFileManagerListener);
        }
        ++this.myIsActive;
    }

    public synchronized void unregisterAsVirtualFileListener() {
        LOG.assertTrue(this.isActive());
        --this.myIsActive;
        if (this.myIsActive == 0) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
            VirtualFileManager.getInstance().removeVirtualFileManagerListener((VirtualFileManagerListener)this.myVirtualFileManagerListener);
            this.myInfoByParentDirectoryPath.clear();
        }
    }

    public void beforePropertyChange(VirtualFilePropertyEvent event) {
        this.processEvent((VirtualFileEvent)event);
    }

    public void beforeContentsChange(VirtualFileEvent event) {
        this.processEvent(event);
    }

    public void contentsChanged(VirtualFileEvent event) {
        CvsEntriesManager.fireStatusChanged(event.getFile());
    }

    @NotNull
    private synchronized CvsInfo getInfoFor(VirtualFile parent) {
        if (!this.myInfoByParentDirectoryPath.containsKey(parent)) {
            CvsInfo cvsInfo = new CvsInfo(parent, this);
            this.myInfoByParentDirectoryPath.put(cvsInfo.getKey(), cvsInfo);
        }
        CvsInfo cvsInfo = this.myInfoByParentDirectoryPath.get(parent);
        if (cvsInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/application/CvsEntriesManager.getInfoFor must not return null");
        }
        return cvsInfo;
    }

    public synchronized void clearCachedFiltersFor(VirtualFile parent) {
        for (VirtualFile file : this.myInfoByParentDirectoryPath.keySet()) {
            if (file == null || !file.isValid() || !VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            this.myInfoByParentDirectoryPath.get(file).clearFilter();
        }
        CvsEntriesManager.fileStatusesChanged();
    }

    private static void fileStatusesChanged() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
        }
    }

    private static boolean isCvsIgnoreFile(VirtualFile file) {
        return ".cvsignore".equals(file.getName());
    }

    public IgnoredFilesInfo getFilter(VirtualFile parent) {
        return this.getInfoFor(parent).getIgnoreFilter();
    }

    public void beforeFileDeletion(VirtualFileEvent event) {
        this.processEvent(event);
    }

    public void beforeFileMovement(VirtualFileMoveEvent event) {
        this.processEvent((VirtualFileEvent)event);
    }

    public void fileCreated(VirtualFileEvent event) {
        this.processEvent(event);
    }

    private void processEvent(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        if (this.isUserHomeCvsIgnoreFile(file)) {
            this.myUserDirIgnores.clearInfo();
            CvsEntriesManager.fileStatusesChanged();
            return;
        }
        if (CvsEntriesManager.isCvsIgnoreFile(file)) {
            this.clearCachedFiltersFor(file.getParent());
            return;
        }
        if (CvsEntriesManager.isCvsAdminDir(file.getParent())) {
            VirtualFile parent = file.getParent().getParent();
            this.clearCachedEntriesFor(parent);
            return;
        }
        if (CvsEntriesManager.isCvsAdminDir(file)) {
            this.clearCachedEntriesFor(file.getParent());
            return;
        }
        if (file.isDirectory()) {
            this.clearCachedEntriesRecursive(file);
        }
    }

    private static boolean isCvsAdminDir(VirtualFile file) {
        if (file == null) {
            return false;
        }
        return file.isDirectory() && CVS_ADMIN_DIRECTORY_NAME.equals(file.getName());
    }

    private synchronized void clearCachedEntriesRecursive(VirtualFile parent) {
        if (!parent.isDirectory()) {
            return;
        }
        for (VirtualFile file : this.myInfoByParentDirectoryPath.keySet()) {
            if (file == null || !file.isValid() || !VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            this.clearCachedEntriesFor(file);
        }
    }

    public Entry getEntryFor(VirtualFile parent, String name) {
        return this.getCvsInfo(parent).getEntryNamed(name);
    }

    public Entry getEntryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/application/CvsEntriesManager.getEntryFor must not be null");
        }
        CvsInfo cvsInfo = this.getCvsInfo(file.getParent());
        assert (cvsInfo != null);
        return cvsInfo.getEntryNamed(file.getName());
    }

    public void clearCachedEntriesFor(final VirtualFile parent) {
        if (parent == null) {
            return;
        }
        CvsInfo cvsInfo = this.getInfoFor(parent);
        cvsInfo.clearFilter();
        if (cvsInfo.isLoaded()) {
            cvsInfo.clearAll();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (parent.isValid()) {
                        CvsEntriesManager.this.onEntriesChanged(parent);
                    }
                }
            });
        }
    }

    @Nullable
    public Entry getCachedEntry(VirtualFile parent, String fileName) {
        if (parent == null) {
            return null;
        }
        CvsInfo cvsInfo = this.getInfoFor(parent);
        if (!cvsInfo.isLoaded()) {
            return null;
        }
        return cvsInfo.getEntryNamed(fileName);
    }

    public void setEntryForFile(final VirtualFile parent, final Entry entry) {
        if (parent == null) {
            return;
        }
        CvsInfo cvsInfo = this.getInfoFor(parent);
        if (!cvsInfo.isLoaded()) {
            return;
        }
        cvsInfo.setEntryAndReturnReplacedEntry(entry);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                VirtualFile file = CvsVfsUtil.findChild(parent, entry.getFileName());
                if (file != null) {
                    CvsEntriesManager.this.onEntryChanged(file);
                }
            }
        });
    }

    public void removeEntryForFile(final File parent, final String fileName) {
        CvsInfo cvsInfo = this.getInfoFor(CvsVfsUtil.findFileByIoFile(parent));
        if (!cvsInfo.isLoaded()) {
            return;
        }
        cvsInfo.removeEntryNamed(fileName);
        final VirtualFile[] file = new VirtualFile[1];
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        file[0] = LocalFileSystem.getInstance().findFileByIoFile(new File(parent, fileName));
                    }
                });
                if (file[0] != null) {
                    CvsEntriesManager.this.onEntryChanged(file[0]);
                }
            }
        });
    }

    private void onEntriesChanged(VirtualFile parent) {
        CvsEntriesListener[] listeners;
        for (CvsEntriesListener listener : listeners = this.myEntriesListeners.toArray(new CvsEntriesListener[this.myEntriesListeners.size()])) {
            listener.entriesChanged(parent);
        }
    }

    private void onEntryChanged(VirtualFile file) {
        CvsEntriesListener[] listeners;
        for (CvsEntriesListener listener : listeners = this.myEntriesListeners.toArray(new CvsEntriesListener[this.myEntriesListeners.size()])) {
            listener.entryChanged(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchForCvsAdminFiles(VirtualFile parent) {
        if (parent == null) {
            return;
        }
        Collection<String> collection = this.myFilesToRefresh;
        synchronized (collection) {
            this.myFilesToRefresh.add(parent.getPath() + "/" + CVS_ADMIN_DIRECTORY_NAME);
        }
    }

    public Collection<Entry> getEntriesIn(VirtualFile parent) {
        return this.getCvsInfo(parent).getEntries();
    }

    private CvsInfo getCvsInfo(VirtualFile parent) {
        if (!this.isActive()) {
            throw new ProcessCanceledException();
        }
        if (parent == null) {
            return CvsInfo.getDummyCvsInfo();
        }
        return this.getInfoFor(parent);
    }

    public void addCvsEntriesListener(CvsEntriesListener listener) {
        this.myEntriesListeners.add(listener);
    }

    public void removeCvsEntriesListener(CvsEntriesListener listener) {
        this.myEntriesListeners.remove(listener);
    }

    public synchronized void clearAll() {
        this.myInfoByParentDirectoryPath.clear();
    }

    public boolean fileIsIgnored(VirtualFile file) {
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return false;
        }
        if (CvsUtil.fileIsUnderCvs(file)) {
            return false;
        }
        return this.getFilter(parent).shouldBeIgnored(file.getName());
    }

    public void lockSynchronizationActions() {
        ++this.mySynchronizationActionLocks;
    }

    public void unlockSynchronizationActions() {
        LOG.assertTrue(this.mySynchronizationActionLocks > 0);
        --this.mySynchronizationActionLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFilesCached() {
        String[] paths;
        Collection<String> collection = this.myFilesToRefresh;
        synchronized (collection) {
            paths = ArrayUtil.toStringArray(this.myFilesToRefresh);
            this.myFilesToRefresh.clear();
        }
        for (String path : paths) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile == null) continue;
            virtualFile.getChildren();
        }
    }

    public CvsConnectionSettings getCvsConnectionSettingsFor(VirtualFile root) {
        return this.getInfoFor(root).getConnectionSettings();
    }

    public CvsConnectionSettings getCvsConnectionSettingsFor(@NotNull File root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/application/CvsEntriesManager.getCvsConnectionSettingsFor must not be null");
        }
        return this.getCvsConnectionSettingsFor(CvsVfsUtil.refreshAndFindFileByIoFile(root));
    }

    public CvsInfo getCvsInfoFor(VirtualFile directory) {
        return this.getInfoFor(directory);
    }

    public CvsConnectionSettings createConnectionSettingsOn(String cvsRoot) {
        if (!this.myStringToSettingsMap.containsKey(cvsRoot)) {
            CvsRootConfiguration rootConfiguration = this.myApplicationLevelConfiguration.getConfigurationForCvsRoot(cvsRoot);
            CvsConnectionSettings settings = new IDEARootFormatter(rootConfiguration).createConfiguration();
            this.myStringToSettingsMap.put(cvsRoot, settings);
        }
        return this.myStringToSettingsMap.get(cvsRoot);
    }

    public UserDirIgnores getUserdIgnores() {
        return this.myUserDirIgnores;
    }

    private static void fireStatusChanged(VirtualFile file) {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManager.getInstance((Project)project).fileStatusChanged(file);
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
        }
    }

    private boolean isUserHomeCvsIgnoreFile(VirtualFile file) {
        return this.myUserDirIgnores.userHomeCvsIgnoreFile().equals(CvsVfsUtil.getFileFor(file));
    }

    public boolean isActive() {
        return this.myIsActive > 0;
    }

    public String getRepositoryFor(VirtualFile root) {
        return this.getInfoFor(root).getRepository();
    }

    public void cacheCvsAdminInfoIn(VirtualFile root) {
        this.getInfoFor(root).cacheAll();
    }

    public String getStickyTagFor(VirtualFile fileByIoFile) {
        return this.getCvsInfo(fileByIoFile).getStickyTag();
    }

    public void encodingChanged() {
        if (!this.isActive()) {
            return;
        }
        this.clearAll();
        CvsEntriesManager.fileStatusesChanged();
    }

    private class MyVirtualFileManagerListener
    implements VirtualFileManagerListener {
        private MyVirtualFileManagerListener() {
        }

        public void afterRefreshFinish(boolean asynchonous) {
            CvsEntriesManager.this.ensureFilesCached();
        }

        public void beforeRefreshStart(boolean asynchonous) {
        }
    }
}

