/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPropertyImpl
extends RegExpElementImpl
implements RegExpProperty {
    private static final String[] UNICODE_BLOCKS;
    public static final String[][] PROPERTY_NAMES;

    public RegExpPropertyImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PsiReference getReference() {
        ASTNode lbrace = this.getNode().findChildByType(RegExpTT.LBRACE);
        if (lbrace == null) {
            return null;
        }
        return new MyPsiReference();
    }

    @Override
    public boolean isNegated() {
        ASTNode node = this.getNode().findChildByType(RegExpTT.PROPERTY);
        return node != null && node.textContains('P');
    }

    @Override
    @Nullable
    public ASTNode getCategoryNode() {
        return this.getNode().findChildByType(RegExpTT.NAME);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpProperty(this);
    }

    public static boolean isValidCategory(String category) {
        if (category.startsWith("In")) {
            try {
                return Character.UnicodeBlock.forName(category.substring(2)) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if (category.startsWith("Is")) {
            category = category.substring(2);
        }
        for (String[] name : PROPERTY_NAMES) {
            if (!name[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    static {
        Field[] fields = Character.UnicodeBlock.class.getFields();
        ArrayList<String> unicodeBlocks = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (!field.getType().equals(Character.UnicodeBlock.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            unicodeBlocks.add("In" + field.getName());
        }
        UNICODE_BLOCKS = ArrayUtil.toStringArray(unicodeBlocks);
        PROPERTY_NAMES = new String[][]{{"Cn", "UNASSIGNED"}, {"Lu", "UPPERCASE_LETTER"}, {"Ll", "LOWERCASE_LETTER"}, {"Lt", "TITLECASE_LETTER"}, {"Lm", "MODIFIER_LETTER"}, {"Lo", "OTHER_LETTER"}, {"Mn", "NON_SPACING_MARK"}, {"Me", "ENCLOSING_MARK"}, {"Mc", "COMBINING_SPACING_MARK"}, {"Nd", "DECIMAL_DIGIT_NUMBER"}, {"Nl", "LETTER_NUMBER"}, {"No", "OTHER_NUMBER"}, {"Zs", "SPACE_SEPARATOR"}, {"Zl", "LINE_SEPARATOR"}, {"Zp", "PARAGRAPH_SEPARATOR"}, {"Cc", "CNTRL"}, {"Cf", "FORMAT"}, {"Co", "PRIVATE USE"}, {"Cs", "SURROGATE"}, {"Pd", "DASH_PUNCTUATION"}, {"Ps", "START_PUNCTUATION"}, {"Pe", "END_PUNCTUATION"}, {"Pc", "CONNECTOR_PUNCTUATION"}, {"Po", "OTHER_PUNCTUATION"}, {"Sm", "MATH_SYMBOL"}, {"Sc", "CURRENCY_SYMBOL"}, {"Sk", "MODIFIER_SYMBOL"}, {"So", "OTHER_SYMBOL"}, {"L", "LETTER"}, {"M", "MARK"}, {"N", "NUMBER"}, {"Z", "SEPARATOR"}, {"C", "CONTROL"}, {"P", "PUNCTUATION"}, {"S", "SYMBOL"}, {"LD", "LETTER_OR_DIGIT"}, {"L1", "Latin-1"}, {"all", "ALL"}, {"ASCII", "ASCII"}, {"Alnum", "Alphanumeric characters"}, {"Alpha", "Alphabetic characters"}, {"Blank", "Space and tab characters"}, {"Cntrl", "Control characters"}, {"Digit", "Numeric characters"}, {"Graph", "printable and visible"}, {"Lower", "Lower-case alphabetic"}, {"Print", "Printable characters"}, {"Punct", "Punctuation characters"}, {"Space", "Space characters"}, {"Upper", "Upper-case alphabetic"}, {"XDigit", "hexadecimal digits"}, {"javaLowerCase"}, {"javaUpperCase"}, {"javaTitleCase"}, {"javaDigit"}, {"javaDefined"}, {"javaLetter"}, {"javaLetterOrDigit"}, {"javaJavaIdentifierStart"}, {"javaJavaIdentifierPart"}, {"javaUnicodeIdentifierStart"}, {"javaUnicodeIdentifierPart"}, {"javaIdentifierIgnorable"}, {"javaSpaceChar"}, {"javaWhitespace"}, {"javaISOControl"}, {"javaMirrored"}};
    }

    private class MyPsiReference
    implements PsiReference {
        private MyPsiReference() {
        }

        public PsiElement getElement() {
            return RegExpPropertyImpl.this;
        }

        public TextRange getRangeInElement() {
            ASTNode lbrace = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.LBRACE);
            assert (lbrace != null);
            ASTNode rbrace = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.RBRACE);
            int to = rbrace == null ? RegExpPropertyImpl.this.getTextRange().getEndOffset() : rbrace.getTextRange().getEndOffset() - 1;
            TextRange t = new TextRange(lbrace.getStartOffset() + 1, to);
            return t.shiftRight(-RegExpPropertyImpl.this.getTextRange().getStartOffset());
        }

        @Nullable
        public PsiElement resolve() {
            return RegExpPropertyImpl.this;
        }

        public String getCanonicalText() {
            return this.getRangeInElement().substring(this.getElement().getText());
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference.bindToElement must not be null");
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Object[] getVariants() {
            Object[] objectArray;
            ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
            if (categoryNode != null && categoryNode.getText().startsWith("In") && !categoryNode.getText().startsWith("Intelli")) {
                objectArray = UNICODE_BLOCKS;
                if (objectArray == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference.getVariants must not return null");
                return objectArray;
            }
            Object[] objects = new Object[PROPERTY_NAMES.length];
            for (int i = 0; i < objects.length; ++i) {
                String[] prop = PROPERTY_NAMES[i];
                objects[i] = new MyLookupValue(prop);
            }
            objectArray = objects;
            if (objects != null) return objectArray;
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference.getVariants must not return null");
        }

        public boolean isSoft() {
            return true;
        }

        private class MyLookupValue
        extends LookupValueFactory.LookupValueWithIcon
        implements LookupValueWithPriority,
        LookupValueWithUIHint {
            private final String[] myProp;

            public MyLookupValue(String[] prop) {
                super(prop[0], Icons.PROPERTY_ICON);
                this.myProp = prop;
            }

            @Override
            public String getPresentation() {
                ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
                if (categoryNode != null && categoryNode.getText().startsWith("Is")) {
                    return "Is" + super.getPresentation();
                }
                return super.getPresentation();
            }

            @Override
            public int getPriority() {
                String name = this.myProp[0];
                if (name.equals("all")) {
                    return 3;
                }
                if (name.startsWith("java")) {
                    return 1;
                }
                return name.length() > 2 ? 2 : 0;
            }

            @Override
            public String getTypeHint() {
                return this.myProp.length > 1 ? this.myProp[1] : "Character.is" + this.myProp[0].substring("java".length()) + "()";
            }

            @Override
            @Nullable
            public Color getColorHint() {
                return null;
            }

            @Override
            public boolean isBold() {
                return false;
            }
        }
    }
}

