/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.XmlBundle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;

public class UIUtils {
    private UIUtils() {
    }

    public static void configureBrowseButton(final Project myProject, final TextFieldWithBrowseButton wsdlUrl, final String[] _extensions, final String selectFileDialogTitle, final boolean multipleFileSelection) {
        wsdlUrl.getButton().setToolTipText(XmlBundle.message((String)"browse.button.tooltip", (Object[])new Object[0]));
        wsdlUrl.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VirtualFile[] virtualFiles;
                VirtualFile fileByPath;
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, multipleFileSelection){
                    private final List<String> extensions;
                    {
                        this.extensions = Arrays.asList(_extensions);
                    }

                    public boolean isFileSelectable(VirtualFile virtualFile) {
                        return this.extensions.contains(virtualFile.getExtension());
                    }

                    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                        return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || this.isFileSelectable(file));
                    }
                };
                fileChooserDescriptor.setTitle(selectFileDialogTitle);
                FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(fileChooserDescriptor, myProject);
                VirtualFile initialFile = myProject.getBaseDir();
                String selectedItem = wsdlUrl.getTextField().getText();
                if (selectedItem != null && selectedItem.startsWith("file://") && (fileByPath = VfsUtil.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(VfsUtil.fixURLforIDEA((String)selectedItem)), null)) != null) {
                    initialFile = fileByPath;
                }
                if ((virtualFiles = fileChooser.choose(initialFile, myProject)).length == 1) {
                    String url = UIUtils.fixIDEAUrl(virtualFiles[0].getUrl());
                    wsdlUrl.setText(url);
                }
            }
        });
    }

    public static String fixIDEAUrl(String url) {
        return SystemInfo.isWindows ? VfsUtil.fixIDEAUrl((String)url) : url;
    }
}

