/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.ui.DebuggerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WatchMessageNode
extends MessageTreeNode
implements WatchNode {
    private final String myExpression;

    private WatchMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String expression, Icon icon) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode.<init> must not be null");
        }
        super(tree, parent, true);
        this.myExpression = expression;
        this.setIcon(icon);
    }

    @Override
    @NotNull
    public String getExpression() {
        String string = this.myExpression;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode.getExpression must not return null");
        }
        return string;
    }

    public static WatchMessageNode createMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, String expression) {
        WatchMessageNode node = new WatchMessageNode(tree, parent, expression, DebuggerIcons.WATCHED_VALUE_ICON);
        node.myText.append(expression, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return node;
    }

    public static WatchMessageNode createEvaluatingNode(XDebuggerTree tree, XDebuggerTreeNode parent, String expression) {
        WatchMessageNode node = new WatchMessageNode(tree, parent, expression, DebuggerIcons.WATCHED_VALUE_ICON);
        node.myText.append(expression + " = ...", XDebuggerUIConstants.EVALUATING_EXPRESSION_HIGHLIGHT_ATTRIBUTES);
        return node;
    }

    public static WatchMessageNode createErrorNode(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String expression, @NotNull String errorMessage) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode.createErrorNode must not be null");
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode.createErrorNode must not be null");
        }
        WatchMessageNode node = new WatchMessageNode(tree, parent, expression, XDebuggerUIConstants.ERROR_MESSAGE_ICON);
        node.myText.append(expression + " = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        node.myText.append(errorMessage, SimpleTextAttributes.ERROR_ATTRIBUTES);
        return node;
    }
}

