/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugViewBase;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerLogConsoleManagerBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionTab
extends DebuggerLogConsoleManagerBase {
    private final String mySessionName;
    private final RunnerLayoutUi myUi;
    private RunContentDescriptor myRunContentDescriptor;
    private ExecutionConsole myConsole;
    private XWatchesView myWatchesView;
    private final List<XDebugViewBase> myViews;

    public XDebugSessionTab(@NotNull Project project, @NotNull String sessionName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.<init> must not be null");
        }
        if (sessionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.<init> must not be null");
        }
        super(project);
        this.myViews = new ArrayList<XDebugViewBase>();
        this.mySessionName = sessionName;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("Debug", "unknown!", sessionName, (Disposable)this);
        this.myUi.getDefaults().initTabDefaults(0, "Debug", null);
        this.myUi.getOptions().setTopToolbar((ActionGroup)XDebugSessionTab.createTopToolbar(), "DebuggerToolbar");
    }

    private Content createConsoleContent() {
        return this.myUi.createContent("ConsoleContent", this.myConsole.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), XDebuggerUIConstants.CONSOLE_TAB_ICON, this.myConsole.getPreferredFocusableComponent());
    }

    private Content createVariablesContent(XDebugSession session) {
        XVariablesView variablesView = new XVariablesView(session, this);
        this.myViews.add(variablesView);
        return this.myUi.createContent("VariablesContent", variablesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), XDebuggerUIConstants.VARIABLES_TAB_ICON, null);
    }

    private Content createWatchesContent(XDebugSession session, XDebugSessionData sessionData) {
        this.myWatchesView = new XWatchesView(session, this, sessionData);
        this.myViews.add(this.myWatchesView);
        Content watchesContent = this.myUi.createContent("WatchesContent", (JComponent)this.myWatchesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), XDebuggerUIConstants.WATCHES_TAB_ICON, null);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("XDebugger.Watches.Tree.Toolbar");
        watchesContent.setActions(group, "DebuggerToolbar", (JComponent)((Object)this.myWatchesView.getTree()));
        return watchesContent;
    }

    private Content createFramesContent(XDebugSession session) {
        XFramesView framesView = new XFramesView(session, this);
        this.myViews.add(framesView);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)framesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), XDebuggerUIConstants.FRAMES_TAB_ICON, null);
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        framesGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)framesView.getFramesList()));
        framesGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)framesView.getFramesList()));
        framesContent.setActions((ActionGroup)framesGroup, "DebuggerToolbar", (JComponent)framesView.getFramesList());
        return framesContent;
    }

    private static DefaultActionGroup createTopToolbar() {
        DefaultActionGroup stepping = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        stepping.add(actionManager.getAction("ShowExecutionPoint"));
        stepping.addSeparator();
        stepping.add(actionManager.getAction("StepOver"));
        stepping.add(actionManager.getAction("StepInto"));
        stepping.add(actionManager.getAction("ForceStepInto"));
        stepping.add(actionManager.getAction("StepOut"));
        stepping.addSeparator();
        stepping.add(actionManager.getAction("RunToCursor"));
        return stepping;
    }

    public XDebugSessionData saveData() {
        List<String> watchExpressions = this.myWatchesView.getWatchExpressions();
        return new XDebugSessionData(ArrayUtil.toStringArray(watchExpressions));
    }

    public ExecutionConsole getConsole() {
        return this.myConsole;
    }

    public String getSessionName() {
        return this.mySessionName;
    }

    public void rebuildViews() {
        for (XDebugViewBase view : this.myViews) {
            view.rebuildView();
        }
    }

    public RunContentDescriptor attachToSession(@NotNull XDebugSession session, @Nullable ProgramRunner runner, @Nullable ExecutionEnvironment env, @NotNull XDebugSessionData sessionData) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.attachToSession must not be null");
        }
        if (sessionData == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.attachToSession must not be null");
        }
        return this.initUI(session, sessionData, env, runner);
    }

    @NotNull
    private static ExecutionResult createExecutionResult(final @NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.createExecutionResult must not be null");
        }
        XDebugProcess debugProcess = session.getDebugProcess();
        ProcessHandler processHandler = debugProcess.getProcessHandler();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                ((XDebugSessionImpl)session).stopImpl();
            }
        });
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(debugProcess.createConsole(), processHandler);
        if (defaultExecutionResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/XDebugSessionTab.createExecutionResult must not return null");
        }
        return defaultExecutionResult;
    }

    public XWatchesView getWatchesView() {
        return this.myWatchesView;
    }

    private RunContentDescriptor initUI(@NotNull XDebugSession session, @NotNull XDebugSessionData sessionData, @Nullable ExecutionEnvironment environment, @Nullable ProgramRunner runner) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.initUI must not be null");
        }
        if (sessionData == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/XDebugSessionTab.initUI must not be null");
        }
        ExecutionResult executionResult = XDebugSessionTab.createExecutionResult(session);
        this.myConsole = executionResult.getExecutionConsole();
        this.myUi.addContent(this.createFramesContent(session), 0, PlaceInGrid.left, false);
        this.myUi.addContent(this.createVariablesContent(session), 0, PlaceInGrid.center, false);
        this.myUi.addContent(this.createWatchesContent(session, sessionData), 0, PlaceInGrid.right, false);
        final Content consoleContent = this.createConsoleContent();
        this.myUi.addContent(consoleContent, 1, PlaceInGrid.bottom, false);
        if (this.myConsole instanceof ObservableConsoleView) {
            ObservableConsoleView observable = (ObservableConsoleView)this.myConsole;
            observable.addChangeListener(new ObservableConsoleView.ChangeListener(){

                public void contentAdded(Collection<ConsoleViewContentType> types) {
                    if (types.contains(ConsoleViewContentType.ERROR_OUTPUT) || types.contains(ConsoleViewContentType.SYSTEM_OUTPUT)) {
                        consoleContent.fireAlert();
                    }
                }
            }, (Disposable)consoleContent);
        }
        session.getDebugProcess().registerAdditionalContent(this.myUi);
        this.myRunContentDescriptor = new RunContentDescriptor(this.myConsole, executionResult.getProcessHandler(), this.myUi.getComponent(), this.getSessionName());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myRunContentDescriptor;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        if (runner != null && environment != null) {
            RestartAction restarAction = new RestartAction(executor, runner, this.myRunContentDescriptor.getProcessHandler(), XDebuggerUIConstants.DEBUG_AGAIN_ICON, this.myRunContentDescriptor, environment);
            group.add((AnAction)restarAction);
            restarAction.registerShortcut(this.myUi.getComponent());
        }
        XDebugSessionTab.addActionToGroup(group, "Resume");
        XDebugSessionTab.addActionToGroup(group, "Pause");
        XDebugSessionTab.addActionToGroup(group, "Stop");
        group.addSeparator();
        XDebugSessionTab.addActionToGroup(group, "ViewBreakpoints");
        XDebugSessionTab.addActionToGroup(group, "XDebugger.MuteBreakpoints");
        group.addSeparator();
        group.addSeparator();
        group.add(this.myUi.getOptions().getLayoutActions());
        group.addSeparator();
        group.add(PinToolwindowTabAction.getPinAction());
        group.add((AnAction)new CloseAction(executor, this.myRunContentDescriptor, this.getProject()));
        group.add((AnAction)new ContextHelpAction(executor.getHelpId()));
        this.myUi.getOptions().setLeftToolbar((ActionGroup)group, "DebuggerToolbar");
        if (environment != null) {
            RunProfile runConfiguration = environment.getRunProfile();
            this.registerFileMatcher(runConfiguration);
            this.initLogConsoles(runConfiguration, this.myRunContentDescriptor.getProcessHandler());
        }
        this.rebuildViews();
        return this.myRunContentDescriptor;
    }

    private static void addActionToGroup(DefaultActionGroup group, String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            group.add(action);
        }
    }

    @Override
    public RunnerLayoutUi getUi() {
        return this.myUi;
    }

    @Override
    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    public void toFront() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectUtil.focusProjectWindow(XDebugSessionTab.this.getProject(), Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint"));
                ExecutionManager.getInstance((Project)XDebugSessionTab.this.getProject()).getContentManager().toFrontRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), XDebugSessionTab.this.myRunContentDescriptor);
            }
        });
    }
}

