/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.actions;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPanelAction;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointsPanel;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoveBreakpointAction<B extends XBreakpoint<?>>
extends XBreakpointPanelAction<B> {
    public RemoveBreakpointAction(XBreakpointsPanel<B> panel) {
        super(panel, XDebuggerBundle.message((String)"xbreakpoints.dialog.button.remove", (Object[])new Object[0]));
    }

    @Override
    public boolean isEnabled(@NotNull Collection<? extends B> breakpoints) {
        if (breakpoints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/actions/RemoveBreakpointAction.isEnabled must not be null");
        }
        return !breakpoints.isEmpty();
    }

    @Override
    public void perform(final @NotNull Collection<? extends B> breakpoints, JComponent parentComponent) {
        if (breakpoints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/actions/RemoveBreakpointAction.perform must not be null");
        }
        final XBreakpointManager breakpointManager = this.myBreakpointsPanel.getBreakpointManager();
        new WriteAction(){

            protected void run(Result result) {
                for (XBreakpoint breakpoint : breakpoints) {
                    breakpointManager.removeBreakpoint(breakpoint);
                }
            }
        }.execute();
        this.myBreakpointsPanel.hideBreakpointProperties();
        this.myBreakpointsPanel.resetBreakpoints();
    }
}

