/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.GuiUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class XBreakpointPropertiesPanel<B extends XBreakpoint<?>> {
    private JPanel myMainPanel;
    private JCheckBox mySuspendCheckBox;
    private JRadioButton mySuspendAllRadioButton;
    private JRadioButton mySuspendThreadRadioButton;
    private JRadioButton mySuspendNoneRadioButton;
    private JCheckBox myLogMessageCheckBox;
    private JCheckBox myLogExpressionCheckBox;
    private JPanel myLogExpressionPanel;
    private JCheckBox myConditionCheckBox;
    private JPanel myConditionExpressionPanel;
    private JPanel myCustomConditionsPanelWrapper;
    private JPanel mySuspendPolicyPanel;
    private JPanel myCustomPropertiesPanelWrapper;
    private JRadioButton myLeaveEnabledRadioButton;
    private JPanel myMasterBreakpointComboBoxPanel;
    private JPanel myAfterBreakpointHitPanel;
    private final XBreakpointManager myBreakpointManager;
    private final B myBreakpoint;
    private final Map<SuspendPolicy, JRadioButton> mySuspendRadioButtons;
    private final List<XBreakpointCustomPropertiesPanel<B>> myCustomPanels;
    private XDebuggerExpressionComboBox myLogExpressionComboBox;
    private XDebuggerExpressionComboBox myConditionComboBox;
    private final ComboBox myMasterBreakpointComboBox;
    private final XDependentBreakpointManager myDependentBreakpointManager;

    public XBreakpointPropertiesPanel(Project project, XBreakpointManager breakpointManager, @NotNull B breakpoint) {
        XBreakpointCustomPropertiesPanel customPropertiesPanel;
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointPropertiesPanel.<init> must not be null");
        }
        this.myBreakpointManager = breakpointManager;
        XBreakpointManagerImpl xBreakpointManagerImpl = (XBreakpointManagerImpl)breakpointManager;
        this.$$$setupUI$$$();
        this.myDependentBreakpointManager = xBreakpointManagerImpl.getDependentBreakpointManager();
        this.myBreakpoint = breakpoint;
        XBreakpointType<B, ?> type = XBreakpointUtil.getType(breakpoint);
        this.mySuspendRadioButtons = new HashMap<SuspendPolicy, JRadioButton>();
        this.mySuspendRadioButtons.put(SuspendPolicy.ALL, this.mySuspendAllRadioButton);
        this.mySuspendRadioButtons.put(SuspendPolicy.THREAD, this.mySuspendThreadRadioButton);
        this.mySuspendRadioButtons.put(SuspendPolicy.NONE, this.mySuspendNoneRadioButton);
        String card = type.isSuspendThreadSupported() ? "radioButtons" : "checkbox";
        ((CardLayout)this.mySuspendPolicyPanel.getLayout()).show(this.mySuspendPolicyPanel, card);
        this.myMasterBreakpointComboBox = new ComboBox(300);
        this.myMasterBreakpointComboBoxPanel.add((Component)this.myMasterBreakpointComboBox, "Center");
        this.myMasterBreakpointComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBreakpointPropertiesPanel.this.updateAfterBreakpointHitPanel();
            }
        });
        this.myMasterBreakpointComboBox.setRenderer(new BreakpointsListCellRenderer());
        this.fillMasterBreakpointComboBox();
        XDebuggerEditorsProvider debuggerEditorsProvider = type.getEditorsProvider();
        if (debuggerEditorsProvider != null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XBreakpointPropertiesPanel.this.onCheckboxChanged();
                }
            };
            this.myLogExpressionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, "breakpointLogExpression", this.myBreakpoint.getSourcePosition());
            JComponent logExpressionComponent = this.myLogExpressionComboBox.getComponent();
            this.myLogExpressionPanel.add((Component)logExpressionComponent, "Center");
            this.myLogExpressionComboBox.setEnabled(false);
            this.myLogExpressionCheckBox.addActionListener(listener);
            DebuggerUIUtil.focusEditorOnCheck(this.myLogExpressionCheckBox, logExpressionComponent);
            this.myConditionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, "breakpointCondition", this.myBreakpoint.getSourcePosition());
            JComponent conditionComponent = this.myConditionComboBox.getComponent();
            this.myConditionExpressionPanel.add((Component)conditionComponent, "Center");
            this.myConditionComboBox.setEnabled(false);
            this.myConditionCheckBox.addActionListener(listener);
            DebuggerUIUtil.focusEditorOnCheck(this.myConditionCheckBox, conditionComponent);
        } else {
            this.myLogExpressionCheckBox.setVisible(false);
            this.myConditionCheckBox.setVisible(false);
        }
        this.myCustomPanels = new ArrayList<XBreakpointCustomPropertiesPanel<B>>();
        XBreakpointCustomPropertiesPanel customConditionPanel = type.createCustomConditionsPanel();
        if (customConditionPanel != null) {
            this.myCustomConditionsPanelWrapper.add((Component)customConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customConditionPanel);
        }
        if ((customPropertiesPanel = type.createCustomPropertiesPanel()) != null) {
            this.myCustomPropertiesPanelWrapper.add((Component)customPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customPropertiesPanel);
        }
        this.loadProperties();
    }

    private void updateAfterBreakpointHitPanel() {
        boolean enable = this.myMasterBreakpointComboBox.getSelectedItem() != null;
        GuiUtils.enableChildren((boolean)enable, (Component[])new Component[]{this.myAfterBreakpointHitPanel});
    }

    private void onCheckboxChanged() {
        if (this.myLogExpressionComboBox != null) {
            this.myLogExpressionComboBox.setEnabled(this.myLogExpressionCheckBox.isSelected());
        }
        if (this.myConditionComboBox != null) {
            this.myConditionComboBox.setEnabled(this.myConditionCheckBox.isSelected());
        }
    }

    private void loadProperties() {
        XBreakpoint<?> masterBreakpoint;
        SuspendPolicy suspendPolicy = this.myBreakpoint.getSuspendPolicy();
        this.mySuspendRadioButtons.get(suspendPolicy).setSelected(true);
        this.mySuspendCheckBox.setSelected(suspendPolicy != SuspendPolicy.NONE);
        this.myLogMessageCheckBox.setSelected(this.myBreakpoint.isLogMessage());
        if (this.myLogExpressionComboBox != null) {
            String logExpression = this.myBreakpoint.getLogExpression();
            this.myLogExpressionCheckBox.setSelected(logExpression != null);
            this.myLogExpressionComboBox.setText(logExpression != null ? logExpression : "");
        }
        if (this.myConditionComboBox != null) {
            String condition = this.myBreakpoint.getCondition();
            this.myConditionCheckBox.setSelected(condition != null);
            this.myConditionComboBox.setText(condition != null ? condition : "");
        }
        if ((masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint((XBreakpoint<?>)this.myBreakpoint)) != null) {
            this.myMasterBreakpointComboBox.setSelectedItem(masterBreakpoint);
            this.myLeaveEnabledRadioButton.setSelected(this.myDependentBreakpointManager.isLeaveEnabled((XBreakpoint<?>)this.myBreakpoint));
        }
        this.updateAfterBreakpointHitPanel();
        for (XBreakpointCustomPropertiesPanel<B> customPanel : this.myCustomPanels) {
            customPanel.loadFrom(this.myBreakpoint);
        }
        this.onCheckboxChanged();
    }

    private void fillMasterBreakpointComboBox() {
        this.myMasterBreakpointComboBox.removeAllItems();
        this.myMasterBreakpointComboBox.addItem(null);
        for (XBreakpoint breakpoint : this.myBreakpointManager.getBreakpoints(XBreakpointUtil.getType(this.myBreakpoint))) {
            if (breakpoint == this.myBreakpoint) continue;
            this.myMasterBreakpointComboBox.addItem((Object)breakpoint);
        }
    }

    public B getBreakpoint() {
        return this.myBreakpoint;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void saveProperties() {
        XBreakpoint masterBreakpoint;
        this.myBreakpoint.setSuspendPolicy(this.getConfiguredSuspendPolicy());
        this.myBreakpoint.setLogMessage(this.myLogMessageCheckBox.isSelected());
        if (this.myLogExpressionComboBox != null) {
            String logExpression = this.myLogExpressionCheckBox.isSelected() ? this.myLogExpressionComboBox.getText() : null;
            this.myBreakpoint.setLogExpression(logExpression);
            this.myLogExpressionComboBox.saveTextInHistory();
        }
        if (this.myConditionComboBox != null) {
            String condition = this.myConditionCheckBox.isSelected() ? this.myConditionComboBox.getText() : null;
            this.myBreakpoint.setCondition(condition);
            this.myConditionComboBox.saveTextInHistory();
        }
        if ((masterBreakpoint = (XBreakpoint)this.myMasterBreakpointComboBox.getSelectedItem()) == null) {
            this.myDependentBreakpointManager.clearMasterBreakpoint((XBreakpoint<?>)this.myBreakpoint);
        } else {
            this.myDependentBreakpointManager.setMasterBreakpoint((XBreakpoint<?>)this.myBreakpoint, (XBreakpoint<?>)masterBreakpoint, this.myLeaveEnabledRadioButton.isSelected());
        }
        for (XBreakpointCustomPropertiesPanel<B> customPanel : this.myCustomPanels) {
            customPanel.saveTo(this.myBreakpoint);
        }
    }

    private SuspendPolicy getConfiguredSuspendPolicy() {
        if (!this.myBreakpoint.getType().isSuspendThreadSupported()) {
            return this.mySuspendCheckBox.isSelected() ? SuspendPolicy.ALL : SuspendPolicy.NONE;
        }
        for (SuspendPolicy policy : this.mySuspendRadioButtons.keySet()) {
            if (!this.mySuspendRadioButtons.get(policy).isSelected()) continue;
            return policy;
        }
        return SuspendPolicy.ALL;
    }

    public void dispose() {
        for (XBreakpointCustomPropertiesPanel<B> customPanel : this.myCustomPanels) {
            customPanel.dispose();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JCheckBox jCheckBox4;
        JPanel jPanel7;
        JPanel jPanel8;
        this.myMainPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 5, 0, 5), -1, -1, false, false));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySuspendPolicyPanel = jPanel7 = new JPanel();
        jPanel7.setLayout(new CardLayout(0, 0));
        jPanel9.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.suspend.group.title"), 0, 0, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel10, "checkbox");
        this.mySuspendCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.suspend.checkbox"));
        jPanel10.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel11, "radioButtons");
        this.mySuspendAllRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.suspend.all.radio"));
        jPanel11.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendThreadRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.suspend.thread.radio"));
        jPanel11.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendNoneRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.suspend.none.radio"));
        jPanel11.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel11.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.properties.actions.group.title"), 0, 0, null, null));
        this.myLogMessageCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.log.message.checkbox"));
        jPanel12.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLogExpressionCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.log.expression.checkbox"));
        jPanel13.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLogExpressionPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel13.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myCustomPropertiesPanelWrapper = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel14, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.group.depends.on"), 0, 0, null, null));
        this.myMasterBreakpointComboBoxPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel14.add((Component)jPanel4, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAfterBreakpointHitPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.label.after.breakpoint.was.hit"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JRadioButton jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.radio.disable.again"));
        jPanel3.add((Component)jRadioButton5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLeaveEnabledRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.radio.leave.enabled"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel15, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel15.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.conditions.group.title"), 0, 0, null, null));
        this.myConditionCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.condition.checkbox"));
        jPanel15.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel15.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConditionExpressionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel15.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myCustomConditionsPanelWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel15.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class BreakpointsListCellRenderer<B extends XBreakpoint<?>>
    extends DefaultListCellRenderer {
        private BreakpointsListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                XBreakpoint breakpoint = (XBreakpoint)value;
                this.setText(XBreakpointUtil.getDisplayText(breakpoint));
                this.setIcon(breakpoint.getType().getEnabledIcon());
            } else {
                this.setText(XDebuggerBundle.message((String)"xbreakpoint.master.breakpoint.none", (Object[])new Object[0]));
                this.setIcon(null);
            }
            return component;
        }
    }
}

