/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.ChangeTrackingValueContainer;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public final class MapIndexStorage<Key, Value>
implements IndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.MapIndexStorage");
    private PersistentHashMap<Key, ValueContainer<Value>> myMap;
    private SLRUCache<Key, ChangeTrackingValueContainer<Value>> myCache;
    private final File myStorageFile;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private final ValueContainerExternalizer<Value> myValueContainerExternalizer;
    private final int myCacheSize;
    private final Lock l = new ReentrantLock();

    public MapIndexStorage(File storageFile, KeyDescriptor<Key> keyDescriptor, DataExternalizer<Value> valueExternalizer, int cacheSize) throws IOException {
        this.myStorageFile = storageFile;
        this.myKeyDescriptor = keyDescriptor;
        this.myValueContainerExternalizer = new ValueContainerExternalizer(valueExternalizer);
        this.myCacheSize = cacheSize;
        this.initMapAndCache();
    }

    private void initMapAndCache() throws IOException {
        final PersistentHashMap map = new PersistentHashMap(this.myStorageFile, this.myKeyDescriptor, this.myValueContainerExternalizer);
        this.myCache = new SLRUCache<Key, ChangeTrackingValueContainer<Value>>(this.myCacheSize, (int)Math.ceil((double)this.myCacheSize * 0.25)){

            @NotNull
            public ChangeTrackingValueContainer<Value> createValue(final Key key) {
                ChangeTrackingValueContainer changeTrackingValueContainer = new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                    @Override
                    public Object getLock() {
                        return map;
                    }

                    public ValueContainer<Value> compute() {
                        ValueContainerImpl value = null;
                        try {
                            value = (ValueContainerImpl)map.get(key);
                            if (value == null) {
                                value = new ValueContainerImpl();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return value;
                    }
                });
                if (changeTrackingValueContainer == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/indexing/MapIndexStorage$1.createValue must not return null");
                }
                return changeTrackingValueContainer;
            }

            protected void onDropFromCache(Key key, ChangeTrackingValueContainer<Value> valueContainer) {
                if (!valueContainer.isDirty()) {
                    return;
                }
                try {
                    if (!valueContainer.needsCompacting()) {
                        ValueContainer toAppend;
                        ValueContainer toRemove;
                        final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        DataOutputStream _out = new DataOutputStream(bytes);
                        TIntHashSet set = valueContainer.getInvalidated();
                        if (set.size() > 0) {
                            for (int inputId : set.toArray()) {
                                MapIndexStorage.this.myValueContainerExternalizer.saveInvalidateCommand(_out, inputId);
                            }
                        }
                        if ((toRemove = valueContainer.getRemovedDelta()).size() > 0) {
                            MapIndexStorage.this.myValueContainerExternalizer.saveAsRemoved(_out, toRemove);
                        }
                        if ((toAppend = valueContainer.getAddedDelta()).size() > 0) {
                            MapIndexStorage.this.myValueContainerExternalizer.save((DataOutput)_out, toAppend);
                        }
                        map.appendData(key, new PersistentHashMap.ValueDataAppender(){

                            public void append(DataOutput out) throws IOException {
                                byte[] barr = bytes.toByteArray();
                                out.write(barr);
                            }
                        });
                    } else {
                        map.put(key, valueContainer);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.myMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.l.lock();
        try {
            if (!this.myMap.isClosed() && this.myMap.isDirty()) {
                this.myCache.clear();
                this.myMap.force();
            }
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public void close() throws StorageException {
        try {
            this.flush();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        try {
            FileUtil.delete((File)this.myStorageFile);
            this.initMapAndCache();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
    }

    @Override
    public boolean processKeys(Processor<Key> processor) throws StorageException {
        this.l.lock();
        try {
            this.myCache.clear();
            boolean bl = this.myMap.processKeys(processor);
            return bl;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public Collection<Key> getKeys() throws StorageException {
        ArrayList keys = new ArrayList();
        this.processKeys((Processor<Key>)new CommonProcessors.CollectProcessor(keys));
        return keys;
    }

    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) throws StorageException {
        ChangeTrackingValueContainer changeTrackingValueContainer;
        this.l.lock();
        try {
            ChangeTrackingValueContainer changeTrackingValueContainer2 = (ChangeTrackingValueContainer)this.myCache.get(key);
            changeTrackingValueContainer = changeTrackingValueContainer2;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
        finally {
            this.l.unlock();
        }
        if (changeTrackingValueContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/MapIndexStorage.read must not return null");
        }
        return changeTrackingValueContainer;
    }

    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        try {
            this.myMap.markDirty();
            ((ChangeTrackingValueContainer)this.read((Object)key)).addValue(inputId, value);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeValue(Key key, int inputId, Value value) throws StorageException {
        try {
            this.myMap.markDirty();
            ((ChangeTrackingValueContainer)this.read((Object)key)).removeValue(inputId, value);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeAllValues(Key key, int inputId) throws StorageException {
        try {
            this.myMap.markDirty();
            ((ChangeTrackingValueContainer)this.read((Object)key)).removeAllValues(inputId);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private static final class ValueContainerExternalizer<T>
    implements DataExternalizer<ValueContainer<T>> {
        private final DataExternalizer<T> myExternalizer;

        private ValueContainerExternalizer(DataExternalizer<T> externalizer) {
            this.myExternalizer = externalizer;
        }

        public void save(DataOutput out, ValueContainer<T> container) throws IOException {
            this.saveImpl(out, container, false);
        }

        public void saveAsRemoved(DataOutput out, ValueContainer<T> container) throws IOException {
            this.saveImpl(out, container, true);
        }

        public void saveInvalidateCommand(DataOutput out, int inputId) throws IOException {
            DataInputOutputUtil.writeSINT((DataOutput)out, (int)(-inputId));
        }

        private void saveImpl(DataOutput out, ValueContainer<T> container, boolean asRemovedData) throws IOException {
            DataInputOutputUtil.writeSINT((DataOutput)out, (int)container.size());
            Iterator<T> valueIterator = container.getValueIterator();
            while (valueIterator.hasNext()) {
                T value = valueIterator.next();
                this.myExternalizer.save(out, value);
                ValueContainer.IntIterator ids = container.getInputIdsIterator(value);
                if (ids != null) {
                    DataInputOutputUtil.writeSINT((DataOutput)out, (int)ids.size());
                    while (ids.hasNext()) {
                        int id = ids.next();
                        DataInputOutputUtil.writeSINT((DataOutput)out, (int)(asRemovedData ? -id : id));
                    }
                    continue;
                }
                DataInputOutputUtil.writeSINT((DataOutput)out, (int)0);
            }
        }

        public ValueContainerImpl<T> read(DataInput in) throws IOException {
            DataInputStream stream = (DataInputStream)in;
            ValueContainerImpl<Object> valueContainer = new ValueContainerImpl<Object>();
            while (stream.available() > 0) {
                int valueCount = DataInputOutputUtil.readSINT((DataInput)in);
                if (valueCount < 0) {
                    valueContainer.removeAllValues(-valueCount);
                    valueContainer.setNeedsCompacting(true);
                    continue;
                }
                for (int valueIdx = 0; valueIdx < valueCount; ++valueIdx) {
                    Object value = this.myExternalizer.read(in);
                    int idCount = DataInputOutputUtil.readSINT((DataInput)in);
                    for (int i = 0; i < idCount; ++i) {
                        int id = DataInputOutputUtil.readSINT((DataInput)in);
                        if (id < 0) {
                            valueContainer.removeValue(-id, value);
                            valueContainer.setNeedsCompacting(true);
                            continue;
                        }
                        valueContainer.addValue(id, value);
                    }
                }
            }
            return valueContainer;
        }
    }
}

