/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileImpl
implements ConfigFile {
    @NotNull
    private ConfigFileInfo myInfo;
    private VirtualFilePointer myFilePointer;
    private PsiFile myPsiFile;
    private final ConfigFileContainerImpl myContainer;
    private final Project myProject;
    private long myModificationCount;
    private final Object myPsiFileLock;
    private final VirtualFilePointerListener myListener;

    public ConfigFileImpl(@NotNull ConfigFileContainerImpl container, @NotNull ConfigFileInfo configuration) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/descriptors/impl/ConfigFileImpl.<init> must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/descriptors/impl/ConfigFileImpl.<init> must not be null");
        }
        this.myPsiFileLock = new Object();
        this.myListener = new VirtualFilePointerListener(){

            public void beforeValidityChanged(VirtualFilePointer[] pointers) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validityChanged(VirtualFilePointer[] pointers) {
                Object object = ConfigFileImpl.this.myPsiFileLock;
                synchronized (object) {
                    ConfigFileImpl.this.myPsiFile = null;
                }
                ConfigFileImpl.this.onChange();
            }
        };
        this.myContainer = container;
        this.myInfo = configuration;
        this.setUrl(configuration.getUrl());
        Disposer.register((Disposable)container, (Disposable)this);
        this.myProject = this.myContainer.getProject();
    }

    private void setUrl(String url) {
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        this.myFilePointer = pointerManager.create(url, (Disposable)this, this.myListener);
        this.onChange();
    }

    private void onChange() {
        ++this.myModificationCount;
        this.myContainer.fireDescriptorChanged(this);
    }

    public String getUrl() {
        return this.myFilePointer.getUrl();
    }

    public void setInfo(@NotNull ConfigFileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/descriptors/impl/ConfigFileImpl.setInfo must not be null");
        }
        this.myInfo = info;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFilePointer.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiFile getPsiFile() {
        PsiFile psiFile;
        Object object = this.myPsiFileLock;
        synchronized (object) {
            psiFile = this.myPsiFile;
        }
        if (psiFile != null && psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        Object object2 = this.myPsiFileLock;
        synchronized (object2) {
            this.myPsiFile = psiFile;
        }
        return psiFile;
    }

    @Nullable
    public XmlFile getXmlFile() {
        PsiFile file = this.getPsiFile();
        return file instanceof XmlFile ? (XmlFile)file : null;
    }

    public void dispose() {
    }

    @NotNull
    public ConfigFileInfo getInfo() {
        ConfigFileInfo configFileInfo = this.myInfo;
        if (configFileInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/descriptors/impl/ConfigFileImpl.getInfo must not return null");
        }
        return configFileInfo;
    }

    public boolean isValid() {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return false;
        }
        if (psiFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)psiFile).getDocument();
            return document != null && document.getRootTag() != null;
        }
        return true;
    }

    @NotNull
    public ConfigFileMetaData getMetaData() {
        ConfigFileMetaData configFileMetaData = this.myInfo.getMetaData();
        if (configFileMetaData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/descriptors/impl/ConfigFileImpl.getMetaData must not return null");
        }
        return configFileMetaData;
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }
}

