/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupFactoryImpl");
    private static final Icon QUICK_LIST_ICON = IconLoader.getIcon((String)"/actions/quickList.png");

    public ListPopup createConfirmation(String title, Runnable onYes, int defaultOptionIndex) {
        return this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
    }

    public ListPopup createConfirmation(String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        return this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
    }

    public JBPopup createMessage(String text) {
        return this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text}));
    }

    public ListPopup createConfirmation(String title, final String yesText, String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (selectedValue.equals(yesText)) {
                    onYes.run();
                } else {
                    onNo.run();
                }
                return FINAL_CHOICE;
            }

            public void canceled() {
                onNo.run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        return app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step) : new MockConfirmation((ListPopupStep)step, yesText);
    }

    private static ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount) {
        return PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, null);
    }

    public ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount) {
        return this.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, null);
    }

    private static ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, final Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition) {
        final Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ActionStepBuilder builder = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        builder.buildGroup(actionGroup);
        List<ActionItem> items = builder.getItems();
        int defaultOptionIndex = 0;
        if (preselectActionCondition != null) {
            for (int i = 0; i < items.size(); ++i) {
                AnAction action = items.get(i).getAction();
                if (!preselectActionCondition.value((Object)action)) continue;
                defaultOptionIndex = i;
                break;
            }
        }
        ActionPopupStep step = new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), defaultOptionIndex, false);
        ListPopupImpl popup = new ListPopupImpl(step, maxRowCount){

            @Override
            public void dispose() {
                if (disposeCallback != null) {
                    disposeCallback.run();
                }
                ActionMenu.showDescriptionInStatusBar(true, component, null);
                super.dispose();
            }
        };
        popup.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                ActionItem actionItem = (ActionItem)list.getSelectedValue();
                if (actionItem == null) {
                    return;
                }
                AnAction action = actionItem.getAction();
                Presentation presentation = new Presentation();
                presentation.setDescription(action.getTemplatePresentation().getDescription());
                action.update(new AnActionEvent(null, DataManager.getInstance().getDataContext(component), "unknown", presentation, ActionManager.getInstance(), 0));
                ActionMenu.showDescriptionInStatusBar(true, component, presentation.getDescription());
            }
        });
        return popup;
    }

    public ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition) {
        return PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition);
    }

    public ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions) {
        return PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod == JBPopupFactory.ActionSelectionAid.NUMBERING || selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, selectionAidMethod == JBPopupFactory.ActionSelectionAid.MNEMONICS, null, -1);
    }

    public ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount) {
        return PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod == JBPopupFactory.ActionSelectionAid.NUMBERING || selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, selectionAidMethod == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount);
    }

    public ListPopupStep createActionsStep(ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics) {
        return this.createActionsStep(actionGroup, dataContext, showNumbers, showDisabledActions, title, component, honorActionMnemonics, 0, false);
    }

    private static ListPopupStep createActionsStep(ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        ActionStepBuilder builder = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        builder.buildGroup(actionGroup);
        List<ActionItem> items = builder.getItems();
        return new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), defaultOptionIndex, autoSelectionEnabled);
    }

    public ListPopupStep createActionsStep(ActionGroup actionGroup, DataContext dataContext, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        return PopupFactoryImpl.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, component, honorActionMnemonics, defaultOptionIndex, autoSelectionEnabled);
    }

    private static boolean itemsHaveMnemonics(List<ActionItem> items) {
        for (ActionItem item : items) {
            if (item.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    public ListPopup createWizardStep(PopupStep step) {
        return new ListPopupImpl((ListPopupStep)step);
    }

    public ListPopup createListPopup(ListPopupStep step) {
        return new ListPopupImpl(step);
    }

    public TreePopup createTree(JBPopup parent, TreePopupStep aStep, Object parentValue) {
        return new TreePopupImpl(parent, aStep, parentValue);
    }

    public TreePopup createTree(TreePopupStep aStep) {
        return new TreePopupImpl(aStep);
    }

    public ComponentPopupBuilder createComponentPopupBuilder(JComponent content, JComponent prefferableFocusComponent) {
        return new ComponentPopupBuilderImpl(content, prefferableFocusComponent);
    }

    public RelativePoint guessBestPopupLocation(DataContext dataContext) {
        Editor editor;
        JComponent focusOwner;
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = focusManager.getFocusOwner();
        JComponent jComponent = focusOwner = component instanceof JComponent ? (JComponent)component : null;
        if (focusOwner == null) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            IdeFrameImpl frame = project == null ? null : ((WindowManagerEx)WindowManager.getInstance()).getFrame(project);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext)) != null && focusOwner == editor.getContentComponent()) {
            return this.guessBestPopupLocation(editor);
        }
        return this.guessBestPopupLocation(focusOwner);
    }

    public RelativePoint guessBestPopupLocation(JComponent component) {
        Point popupMenuPoint = null;
        Rectangle visibleRect = component.getVisibleRect();
        if (component instanceof JList) {
            int[] selectedIndices;
            JList list = (JList)component;
            int firstVisibleIndex = list.getFirstVisibleIndex();
            int lastVisibleIndex = list.getLastVisibleIndex();
            for (int index : selectedIndices = list.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height);
                break;
            }
        } else if (component instanceof JTree) {
            JTree tree = (JTree)component;
            int[] selectionRows = tree.getSelectionRows();
            for (int i = 0; selectionRows != null && i < selectionRows.length; ++i) {
                int row = selectionRows[i];
                Rectangle rowBounds = tree.getRowBounds(row);
                if (visibleRect.y > rowBounds.y || rowBounds.y > visibleRect.y + visibleRect.height) continue;
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, rowBounds.y + rowBounds.height);
                break;
            }
        } else if (component instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        return new RelativePoint((Component)component, popupMenuPoint);
    }

    public RelativePoint guessBestPopupLocation(Editor editor) {
        VisualPosition logicalPosition = editor.getCaretModel().getVisualPosition();
        Point p = editor.visualPositionToXY(new VisualPosition(logicalPosition.line + 1, logicalPosition.column));
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(p)) {
            p = new Point((visibleArea.x + visibleArea.width) / 2, (visibleArea.y + visibleArea.height) / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    public Point getCenterOf(JComponent container, JComponent content) {
        return AbstractPopup.getCenterOf(container, content);
    }

    @Nullable
    public List<JBPopup> getChildPopups(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl.getChildPopups must not be null");
        }
        return FocusTrackback.getChildPopups(component);
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl.createBalloonBuilder must not be null");
        }
        return new BalloonPopupBuilderImpl(content);
    }

    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon, Color fillColor, @Nullable HyperlinkListener listener) {
        if (htmlContent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl.createHtmlTextBalloonBuilder must not be null");
        }
        JEditorPane text = new JEditorPane();
        text.setEditorKit(new HTMLEditorKit());
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        text.setText(UIUtil.toHtml((String)htmlContent));
        JLabel label = new JLabel(text.getText());
        Dimension size = label.getPreferredSize();
        text.setEditable(false);
        text.setOpaque(false);
        text.setBorder(null);
        text.setPreferredSize(size);
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        textWrapper.add((Component)text);
        content.add((Component)textWrapper, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(icon), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        BalloonBuilder builder = this.createBalloonBuilder((JComponent)content);
        builder.setFillColor(fillColor);
        return builder;
    }

    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener) {
        if (htmlContent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl.createHtmlTextBalloonBuilder must not be null");
        }
        return this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener);
    }

    private static class ActionStepBuilder {
        private final List<ActionItem> myListModel;
        private final DataContext myDataContext;
        private final boolean myShowNumbers;
        private final boolean myUseAlphaAsNumbers;
        private final boolean myShowDisabled;
        private final HashMap<AnAction, Presentation> myAction2presentation;
        private int myCurrentNumber;
        private boolean myPrependWithSeparator;
        private String mySeparatorText;
        private final boolean myHonorActionMnemonics;
        private Icon myEmptyIcon;
        private int myMaxIconWidth = -1;
        private int myMaxIconHeight = -1;

        private ActionStepBuilder(DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics) {
            this.myUseAlphaAsNumbers = useAlphaAsNumbers;
            this.myListModel = new ArrayList<ActionItem>();
            this.myDataContext = dataContext;
            this.myShowNumbers = showNumbers;
            this.myShowDisabled = showDisabled;
            this.myAction2presentation = new HashMap();
            this.myCurrentNumber = 0;
            this.myPrependWithSeparator = false;
            this.mySeparatorText = null;
            this.myHonorActionMnemonics = honorActionMnemonics;
        }

        public List<ActionItem> getItems() {
            return this.myListModel;
        }

        public void buildGroup(ActionGroup actionGroup) {
            this.calcMaxIconSize(actionGroup);
            this.myEmptyIcon = this.myMaxIconHeight != -1 && this.myMaxIconWidth != -1 ? new EmptyIcon(this.myMaxIconWidth, this.myMaxIconHeight) : null;
            this.appendActionsFromGroup(actionGroup);
            if (this.myListModel.isEmpty()) {
                this.myListModel.add(new ActionItem(Utils.EMPTY_MENU_FILLER, "Nothing here", false, null, false, null));
            }
        }

        private void calcMaxIconSize(ActionGroup actionGroup) {
            AnAction[] actions;
            for (AnAction action : actions = actionGroup.getChildren(new AnActionEvent(null, this.myDataContext, "unknown", this.getPresentation((AnAction)actionGroup), ActionManager.getInstance(), 0))) {
                ActionGroup group;
                if (action == null) continue;
                if (action instanceof ActionGroup && !(group = (ActionGroup)action).isPopup()) {
                    this.calcMaxIconSize(group);
                    continue;
                }
                Icon icon = action.getTemplatePresentation().getIcon();
                if (icon == null) continue;
                int width = icon.getIconWidth();
                int height = icon.getIconHeight();
                if (this.myMaxIconWidth < width) {
                    this.myMaxIconWidth = width;
                }
                if (this.myMaxIconHeight >= height) continue;
                this.myMaxIconHeight = height;
            }
        }

        private void appendActionsFromGroup(ActionGroup actionGroup) {
            AnAction[] actions;
            for (AnAction action : actions = actionGroup.getChildren(new AnActionEvent(null, this.myDataContext, "unknown", this.getPresentation((AnAction)actionGroup), ActionManager.getInstance(), 0))) {
                if (action instanceof Separator) {
                    this.myPrependWithSeparator = true;
                    this.mySeparatorText = ((Separator)action).getText();
                    continue;
                }
                if (action instanceof ActionGroup) {
                    ActionGroup group = (ActionGroup)action;
                    if (group.isPopup()) {
                        this.appendAction((AnAction)group);
                        continue;
                    }
                    this.appendActionsFromGroup(group);
                    continue;
                }
                this.appendAction(action);
            }
        }

        private void appendAction(AnAction action) {
            Presentation presentation = this.getPresentation(action);
            AnActionEvent event = new AnActionEvent(null, this.myDataContext, "unknown", presentation, ActionManager.getInstance(), 0);
            ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)event, (boolean)true);
            if ((this.myShowDisabled || presentation.isEnabled()) && presentation.isVisible()) {
                boolean prependSeparator;
                String text = presentation.getText();
                if (this.myShowNumbers) {
                    if (this.myCurrentNumber < 9) {
                        text = "&" + (this.myCurrentNumber + 1) + ". " + text;
                    } else if (this.myCurrentNumber == 9) {
                        text = "&0. " + text;
                    } else if (this.myUseAlphaAsNumbers) {
                        text = "&" + (char)(65 + this.myCurrentNumber - 10) + ". " + text;
                    }
                    ++this.myCurrentNumber;
                } else if (this.myHonorActionMnemonics) {
                    text = Presentation.restoreTextWithMnemonic((String)text, (int)action.getTemplatePresentation().getMnemonic());
                }
                Icon icon = presentation.getIcon();
                if (icon == null) {
                    String actionId = ActionManager.getInstance().getId(action);
                    icon = actionId != null && actionId.startsWith("QuickList.") ? QUICK_LIST_ICON : this.myEmptyIcon;
                }
                boolean bl = prependSeparator = !this.myListModel.isEmpty() && this.myPrependWithSeparator;
                assert (text != null) : action + " has no presentation";
                this.myListModel.add(new ActionItem(action, text, presentation.isEnabled(), icon, prependSeparator, this.mySeparatorText));
                this.myPrependWithSeparator = false;
                this.mySeparatorText = null;
            }
        }

        private Presentation getPresentation(AnAction action) {
            Presentation presentation = this.myAction2presentation.get(action);
            if (presentation == null) {
                presentation = (Presentation)action.getTemplatePresentation().clone();
                this.myAction2presentation.put(action, presentation);
            }
            return presentation;
        }
    }

    private static class ActionPopupStep
    implements ListPopupStep<ActionItem>,
    MnemonicNavigationFilter<ActionItem>,
    SpeedSearchFilter<ActionItem> {
        private final List<ActionItem> myItems;
        private final String myTitle;
        private final Component myContext;
        private final boolean myEnableMnemonics;
        private final int myDefaultOptionIndex;
        private final boolean myAutoSelectionEnabled;
        private Runnable myFinalRunnable;

        private ActionPopupStep(@NotNull List<ActionItem> items, String title, Component context, boolean enableMnemonics, int defaultOptionIndex, boolean autoSelection) {
            if (items == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep.<init> must not be null");
            }
            this.myItems = items;
            this.myTitle = title;
            this.myContext = context;
            this.myEnableMnemonics = enableMnemonics;
            this.myDefaultOptionIndex = defaultOptionIndex;
            this.myAutoSelectionEnabled = autoSelection;
        }

        @NotNull
        public List<ActionItem> getValues() {
            List<ActionItem> list = this.myItems;
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep.getValues must not return null");
            }
            return list;
        }

        public boolean isSelectable(ActionItem value) {
            return value.isEnabled();
        }

        public int getMnemonicPos(ActionItem value) {
            String text = this.getTextFor(value);
            int i = text.indexOf(27);
            if (i < 0) {
                i = text.indexOf(38);
            }
            if (i < 0) {
                i = text.indexOf(95);
            }
            return i;
        }

        public Icon getIconFor(ActionItem aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionItem value) {
            String string = value.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep.getTextFor must not return null");
            }
            return string;
        }

        public ListSeparator getSeparatorAbove(ActionItem value) {
            return value.isPrependWithSeparator() ? new ListSeparator(value.getSeparatorText()) : null;
        }

        public int getDefaultOptionIndex() {
            return this.myDefaultOptionIndex;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public PopupStep onChosen(ActionItem actionChoice, boolean finalChoice) {
            DataContext dataContext;
            if (!actionChoice.isEnabled()) {
                return FINAL_CHOICE;
            }
            final AnAction action = actionChoice.getAction();
            DataManager mgr = DataManager.getInstance();
            DataContext dataContext2 = dataContext = this.myContext != null ? mgr.getDataContext(this.myContext) : mgr.getDataContext();
            if (!(!(action instanceof ActionGroup) || finalChoice && ((ActionGroup)action).canBePerformed(dataContext))) {
                return JBPopupFactory.getInstance().createActionsStep((ActionGroup)action, dataContext, this.myEnableMnemonics, false, null, this.myContext, false);
            }
            this.myFinalRunnable = new Runnable(){

                @Override
                public void run() {
                    action.actionPerformed(new AnActionEvent(null, dataContext, "unknown", (Presentation)action.getTemplatePresentation().clone(), ActionManager.getInstance(), 0));
                }
            };
            return FINAL_CHOICE;
        }

        public Runnable getFinalRunnable() {
            return this.myFinalRunnable;
        }

        public boolean hasSubstep(ActionItem selectedValue) {
            return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup;
        }

        public void canceled() {
        }

        public boolean isMnemonicsNavigationEnabled() {
            return this.myEnableMnemonics;
        }

        public MnemonicNavigationFilter<ActionItem> getMnemonicNavigationFilter() {
            return this;
        }

        public boolean canBeHidden(ActionItem value) {
            return true;
        }

        public String getIndexedString(ActionItem value) {
            return this.getTextFor(value);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return this.myAutoSelectionEnabled;
        }

        public SpeedSearchFilter<ActionItem> getSpeedSearchFilter() {
            return this;
        }
    }

    private static class ActionItem {
        private final AnAction myAction;
        private final String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final boolean myPrependWithSeparator;
        private final String mySeparatorText;

        private ActionItem(@NotNull AnAction action, @NotNull String text, boolean enabled, Icon icon, boolean prependWithSeparator, String separatorText) {
            if (action == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl$ActionItem.<init> must not be null");
            }
            if (text == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/popup/PopupFactoryImpl$ActionItem.<init> must not be null");
            }
            this.myAction = action;
            this.myText = text;
            this.myIsEnabled = enabled;
            this.myIcon = icon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ui/popup/PopupFactoryImpl$ActionItem.getAction must not return null");
            }
            return anAction;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ui/popup/PopupFactoryImpl$ActionItem.getText must not return null");
            }
            return string;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }
    }
}

