/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public interface PopupComponent {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupComponent");

    public void hide(boolean var1);

    public void show();

    public Window getWindow();

    public static class AwtPopupWrapper
    implements PopupComponent {
        private Popup myPopup;

        public AwtPopupWrapper(Popup popup) {
            this.myPopup = popup;
        }

        @Override
        public void hide(boolean dispose) {
            this.myPopup.hide();
        }

        @Override
        public void show() {
            this.myPopup.show();
        }

        @Override
        public Window getWindow() {
            Component c = (Component)ReflectionUtil.getField(Popup.class, (Object)this.myPopup, Component.class, (String)"component");
            return c instanceof JWindow ? (JWindow)c : null;
        }
    }

    public static class DialogPopupWrapper
    implements PopupComponent {
        private JDialog myDialog;

        public DialogPopupWrapper(Component owner, Component content, int x, int y) {
            if (!owner.isShowing()) {
                throw new IllegalArgumentException("Popup owner must be showing");
            }
            Window wnd = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
            this.myDialog = wnd instanceof Frame ? new JDialog((Frame)wnd, false) : new JDialog((Dialog)wnd, false);
            this.myDialog.getContentPane().setLayout(new BorderLayout());
            this.myDialog.getContentPane().add(content, "Center");
            this.myDialog.setUndecorated(true);
            this.myDialog.pack();
            this.myDialog.setLocation(x, y);
        }

        @Override
        public Window getWindow() {
            return this.myDialog;
        }

        @Override
        public void hide(boolean dispose) {
            this.myDialog.setVisible(false);
            if (dispose) {
                this.myDialog.dispose();
            }
        }

        @Override
        public void show() {
            this.myDialog.setVisible(true);
        }
    }

    public static interface Factory {
        public PopupComponent getPopup(Component var1, Component var2, int var3, int var4);

        public boolean isNativePopup();

        public static class Dialog
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content, int x, int y) {
                return new DialogPopupWrapper(owner, content, x, y);
            }

            @Override
            public boolean isNativePopup() {
                return false;
            }
        }

        public static class AwtHeavyweight
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content, int x, int y) {
                PopupFactory factory = PopupFactory.getSharedInstance();
                try {
                    Method method = PopupFactory.class.getDeclaredMethod("setPopupType", Integer.TYPE);
                    method.setAccessible(true);
                    method.invoke((Object)factory, 2);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                return new AwtPopupWrapper(factory.getPopup(owner, content, x, y));
            }

            @Override
            public boolean isNativePopup() {
                return true;
            }
        }

        public static class AwtDefault
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content, int x, int y) {
                return new AwtPopupWrapper(PopupFactory.getSharedInstance().getPopup(owner, content, x, y));
            }

            @Override
            public boolean isNativePopup() {
                return true;
            }
        }
    }
}

