/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceDereferenceUsage;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.TextChunk;
import java.awt.Color;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class SliceUsageCellRenderer
extends ColoredTreeCellRenderer {
    private static final EditorColorsScheme ourColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
    public static final SimpleTextAttributes ourInvalidAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)ourColorsScheme.getAttributes(UsageTreeColors.INVALID_PREFIX));

    public SliceUsageCellRenderer() {
        this.setOpaque(false);
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        assert (value instanceof DefaultMutableTreeNode);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        if (userObject == null) {
            return;
        }
        if (userObject instanceof MyColoredTreeCellRenderer) {
            MyColoredTreeCellRenderer node = (MyColoredTreeCellRenderer)userObject;
            node.customizeCellRenderer(this, tree, value, selected, expanded, leaf, row, hasFocus);
            if (node instanceof SliceNode) {
                this.setToolTipText(((SliceNode)node).getPresentation().getTooltip());
            }
        } else {
            this.append(userObject.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    public void customizeCellRendererFor(SliceUsage sliceUsage) {
        String location;
        PsiMethod method;
        PsiClass aClass;
        SimpleTextAttributes attributes;
        TextChunk[] text;
        boolean isForcedLeaf = sliceUsage instanceof SliceDereferenceUsage;
        for (TextChunk textChunk : text = sliceUsage.getPresentation().getText()) {
            attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textChunk.getAttributes());
            if (isForcedLeaf) {
                attributes = attributes.derive(attributes.getStyle(), Color.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            this.append(textChunk.getText(), attributes);
        }
        PsiElement element = sliceUsage.getElement();
        while (true) {
            PsiClass psiClass = aClass = (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) : method.getContainingClass();
            if (!(aClass instanceof PsiAnonymousClass)) break;
            element = aClass;
        }
        String string = method != null ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2, (int)2) : (location = aClass != null ? PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) : null);
        if (location != null) {
            attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(" in " + location, attributes);
        }
    }
}

