/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemServiceImpl
extends SemService {
    private static final Comparator<SemKey> KEY_COMPARATOR = new Comparator<SemKey>(){

        @Override
        public int compare(SemKey o1, SemKey o2) {
            return o2.getUniqueId() - o1.getUniqueId();
        }
    };
    private final ConcurrentMap<PsiElement, ConcurrentMap<SemKey, List<SemElement>>> myCache = new ConcurrentHashMap();
    private final Map<SemKey, Collection<NullableFunction<PsiElement, ? extends SemElement>>> myProducers = new THashMap();
    private final MultiMap<SemKey, SemKey> myInheritors = new MultiMap();
    private final Project myProject;
    private volatile boolean myInitialized = false;
    private boolean myBulkChange = false;

    public SemServiceImpl(Project project, PsiManager psiManager) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ProjectTopics.MODIFICATION_TRACKER, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                if (!SemServiceImpl.this.isInsideAtomicChange()) {
                    SemServiceImpl.this.clearCache();
                }
            }
        });
        ((PsiManagerEx)psiManager).registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                if (!SemServiceImpl.this.isInsideAtomicChange()) {
                    SemServiceImpl.this.clearCache();
                }
            }
        });
    }

    public void clearCache() {
        this.myCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/semantic/SemServiceImpl.performAtomicChange must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean oldValue = this.myBulkChange;
        this.myBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.myBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
    }

    public boolean isInsideAtomicChange() {
        return this.myBulkChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (this.myInitialized) {
            return;
        }
        final MultiMap map = new MultiMap();
        SemRegistrar registrar = new SemRegistrar(){

            public <T extends SemElement, V extends PsiElement> void registerSemElementProvider(SemKey<T> key, final ElementPattern<? extends V> place, final NullableFunction<V, T> provider) {
                map.putValue(key, (Object)new NullableFunction<PsiElement, SemElement>(){

                    public SemElement fun(PsiElement element) {
                        if (place.accepts((Object)element)) {
                            return (SemElement)provider.fun((Object)element);
                        }
                        return null;
                    }
                });
            }
        };
        for (SemContributor contributor : (SemContributor[])this.myProject.getExtensions(SemContributor.EP_NAME)) {
            contributor.registerSemProviders(registrar);
        }
        ConcurrentMap<PsiElement, ConcurrentMap<SemKey, List<SemElement>>> concurrentMap = this.myCache;
        synchronized (concurrentMap) {
            Object[] allKeys;
            if (this.myInitialized) {
                return;
            }
            assert (this.myProducers.isEmpty());
            assert (this.myInheritors.isEmpty());
            for (SemKey semKey : allKeys = map.keySet().toArray(new SemKey[map.size()])) {
                this.myProducers.put(semKey, map.get((Object)semKey));
            }
            ContainerUtil.process((Object[])allKeys, (Processor)new Processor<SemKey>(){

                public boolean process(SemKey key) {
                    SemServiceImpl.this.myInheritors.putValue((Object)key, (Object)key);
                    for (SemKey parent : key.getSupers()) {
                        SemServiceImpl.this.myInheritors.putValue((Object)parent, (Object)key);
                        this.process(parent);
                    }
                    return true;
                }
            });
            for (SemKey each : this.myInheritors.keySet()) {
                ArrayList inheritors = new ArrayList(this.myInheritors.get((Object)each));
                Collections.sort(inheritors, KEY_COMPARATOR);
                this.myInheritors.put((Object)each, inheritors);
            }
            this.myInitialized = true;
        }
    }

    @Nullable
    public <T extends SemElement> List<T> getSemElements(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/semantic/SemServiceImpl.getSemElements must not be null");
        }
        this.ensureInitialized();
        List<T> cached = this._getCachedSemElements(key, psi, true);
        if (cached != null) {
            return cached;
        }
        ConcurrentMap<SemKey, List<SemElement>> map = this.cacheOrGetMap(psi);
        LinkedHashSet result = null;
        for (SemKey each : this.myInheritors.get(key)) {
            List list = (List)ConcurrencyUtil.cacheOrGet(map, (Object)each, this.createSemElements(each, psi));
            if (list.isEmpty()) continue;
            if (result == null) {
                result = new LinkedHashSet();
            }
            result.addAll(list);
        }
        return result == null ? Collections.emptyList() : new ArrayList(result);
    }

    @NotNull
    private List<SemElement> createSemElements(SemKey key, PsiElement psi) {
        List result = null;
        Collection<NullableFunction<PsiElement, ? extends SemElement>> producers = this.myProducers.get(key);
        if (producers != null && !producers.isEmpty()) {
            for (NullableFunction<PsiElement, ? extends SemElement> producer : producers) {
                SemElement element = (SemElement)producer.fun((Object)psi);
                if (element == null) continue;
                if (result == null) {
                    result = new SmartList();
                }
                result.add(element);
            }
        }
        List<Object> list = result == null ? Collections.emptyList() : Collections.unmodifiableList(result);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/semantic/SemServiceImpl.createSemElements must not return null");
        }
        return list;
    }

    @Nullable
    public <T extends SemElement> List<T> getCachedSemElements(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/semantic/SemServiceImpl.getCachedSemElements must not be null");
        }
        return this._getCachedSemElements(key, psi, false);
    }

    @Nullable
    private <T extends SemElement> List<T> _getCachedSemElements(SemKey<T> key, PsiElement psi, boolean paranoid) {
        ConcurrentMap map = (ConcurrentMap)this.myCache.get(psi);
        if (map == null) {
            return null;
        }
        List singleList = null;
        LinkedHashSet result = null;
        List inheritors = (List)this.myInheritors.get(key);
        for (int i = 0; i < inheritors.size(); ++i) {
            List cached = (List)map.get(inheritors.get(i));
            if (cached == null && paranoid) {
                return null;
            }
            if (cached == null || cached == Collections.EMPTY_LIST) continue;
            if (singleList == null) {
                singleList = cached;
                continue;
            }
            if (result == null) {
                result = new LinkedHashSet(singleList);
            }
            result.addAll(cached);
        }
        if (result == null) {
            if (singleList != null) {
                return singleList;
            }
            return Collections.emptyList();
        }
        return new ArrayList(result);
    }

    public <T extends SemElement> void setCachedSemElement(SemKey<T> key, @NotNull PsiElement psi, @Nullable T semElement) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/semantic/SemServiceImpl.setCachedSemElement must not be null");
        }
        this.cacheOrGetMap(psi).put(key, ContainerUtil.createMaybeSingletonList(semElement));
    }

    public <T extends SemElement> void clearCachedSemElements(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/semantic/SemServiceImpl.clearCachedSemElements must not be null");
        }
        this.myCache.remove(psi);
    }

    private ConcurrentMap<SemKey, List<SemElement>> cacheOrGetMap(PsiElement psi) {
        ConcurrentMap map = (ConcurrentMap)this.myCache.get(psi);
        if (map == null) {
            map = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)psi, (Object)new ConcurrentHashMap());
        }
        return map;
    }
}

