/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VariableInplaceRenamer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.inplace.VariableInplaceRenamer");
    public static final LanguageExtension<ResolveSnapshotProvider> INSTANCE = new LanguageExtension("com.intellij.rename.inplace.resolveSnapshotProvider");
    private final PsiNameIdentifierOwner myElementToRename;
    @NonNls
    private static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    private ArrayList<RangeHighlighter> myHighlighters;
    private final Editor myEditor;
    private final Project myProject;
    private static final Stack<VariableInplaceRenamer> ourRenamersStack = new Stack();

    public VariableInplaceRenamer(PsiNameIdentifierOwner elementToRename, Editor editor) {
        this.myElementToRename = elementToRename;
        this.myEditor = editor;
        this.myProject = this.myElementToRename.getProject();
    }

    public boolean performInplaceRename() {
        String stringToSearch;
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix((PsiElement)this.myElementToRename)) {
            return false;
        }
        Collection refs = ReferencesSearch.search((PsiElement)this.myElementToRename).findAll();
        PsiFile myEditorFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiReference reference = (myEditorFile != null ? myEditorFile : this.myElementToRename.getContainingFile()).findReferenceAt(this.myEditor.getCaretModel().getOffset());
        if (reference != null && !refs.contains(reference)) {
            refs.add(reference);
        }
        FileViewProvider fileViewProvider = this.myElementToRename.getContainingFile().getViewProvider();
        VirtualFile file = VariableInplaceRenamer.getTopLevelVirtualFile(fileViewProvider);
        for (PsiReference ref : refs) {
            FileViewProvider usageViewProvider = ref.getElement().getContainingFile().getViewProvider();
            if (VariableInplaceRenamer.getTopLevelVirtualFile(usageViewProvider) == file) continue;
            return false;
        }
        while (!ourRenamersStack.isEmpty()) {
            ((VariableInplaceRenamer)ourRenamersStack.peek()).finish();
        }
        ourRenamersStack.push((Object)this);
        THashMap rangesToHighlight = new THashMap();
        this.collectElementsToHighlight((Map<TextRange, TextAttributes>)rangesToHighlight, refs);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        PsiElement scope = null;
        SearchScope searchScope = this.myElementToRename.getUseScope();
        if (searchScope instanceof LocalSearchScope) {
            PsiElement[] elements = ((LocalSearchScope)searchScope).getScope();
            scope = PsiTreeUtil.findCommonParent((PsiElement[])elements);
        }
        if (scope == null) {
            return false;
        }
        final PsiFile containingFile = scope.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        PsiElement context = containingFile.getContext();
        if (context != null) {
            scope = context.getContainingFile();
        }
        if ((stringToSearch = this.myElementToRename.getName()) != null && !TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myElementToRename, stringToSearch, true, new PairProcessor<PsiElement, TextRange>(){

            public boolean process(PsiElement psiElement, TextRange textRange) {
                return false;
            }
        })) {
            return false;
        }
        ResolveSnapshotProvider resolveSnapshotProvider = (ResolveSnapshotProvider)INSTANCE.forLanguage(scope.getLanguage());
        final ResolveSnapshotProvider.ResolveSnapshot snapshot = resolveSnapshotProvider != null ? resolveSnapshotProvider.createSnapshot(scope) : null;
        final TemplateBuilderImpl builder = new TemplateBuilderImpl(scope);
        PsiElement nameIdentifier = this.myElementToRename.getNameIdentifier();
        PsiElement selectedElement = VariableInplaceRenamer.getSelectedInEditorElement(nameIdentifier, refs, this.myEditor.getCaretModel().getOffset());
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)this.myElementToRename)) {
            return true;
        }
        if (nameIdentifier != null) {
            this.addVariable(nameIdentifier, selectedElement, builder);
        }
        for (PsiReference ref : refs) {
            this.addVariable(ref, selectedElement, builder);
        }
        final PsiElement scope1 = scope;
        final int renameOffset = this.myElementToRename.getTextOffset();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable((Map)rangesToHighlight, highlightManager){
            final /* synthetic */ Map val$rangesToHighlight;
            final /* synthetic */ HighlightManager val$highlightManager;
            {
                this.val$rangesToHighlight = map;
                this.val$highlightManager = highlightManager;
            }

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        boolean lookupShown;
                        int offset = VariableInplaceRenamer.this.myEditor.getCaretModel().getOffset();
                        Template template = builder.buildInlineTemplate();
                        template.setToShortenLongNames(false);
                        TextRange range = scope1.getTextRange();
                        assert (range != null);
                        VariableInplaceRenamer.this.myHighlighters = new ArrayList();
                        Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(VariableInplaceRenamer.this.myEditor);
                        topLevelEditor.getCaretModel().moveToOffset(range.getStartOffset());
                        TemplateManager.getInstance(VariableInplaceRenamer.this.myProject).startTemplate(topLevelEditor, template, new TemplateEditingAdapter(){
                            private String myNewName = null;

                            @Override
                            public void beforeTemplateFinished(TemplateState templateState, Template template) {
                                TextResult value;
                                VariableInplaceRenamer.this.finish();
                                if (snapshot != null && (value = templateState.getVariableValue(VariableInplaceRenamer.PRIMARY_VARIABLE_NAME)) != null) {
                                    this.myNewName = value.toString();
                                    if (((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(scope1.getLanguage())).isIdentifier(this.myNewName, VariableInplaceRenamer.this.myProject)) {
                                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                            @Override
                                            public void run() {
                                                snapshot.apply(myNewName);
                                            }
                                        });
                                    }
                                }
                            }

                            @Override
                            public void templateFinished(Template template, boolean brokenOff) {
                                super.templateFinished(template, brokenOff);
                                if (this.myNewName != null) {
                                    VariableInplaceRenamer.this.performAutomaticRename(this.myNewName, PsiTreeUtil.getParentOfType((PsiElement)containingFile.findElementAt(renameOffset), PsiNameIdentifierOwner.class));
                                }
                            }

                            @Override
                            public void templateCancelled(Template template) {
                                VariableInplaceRenamer.this.finish();
                            }
                        });
                        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(VariableInplaceRenamer.this.myEditor);
                        boolean bl = lookupShown = lookup != null && lookup.getLookupStart() < offset;
                        if (lookupShown) {
                            lookup.setAdditionalPrefix(((Object)VariableInplaceRenamer.this.myEditor.getDocument().getCharsSequence().subSequence(lookup.getLookupStart(), offset)).toString());
                        }
                        VariableInplaceRenamer.this.myEditor.getCaretModel().moveToOffset(offset);
                        if (lookupShown) {
                            lookup.setAdditionalPrefix("");
                        }
                        VariableInplaceRenamer.addHighlights(val$rangesToHighlight, topLevelEditor, VariableInplaceRenamer.this.myHighlighters, val$highlightManager);
                    }
                });
            }
        }, RefactoringBundle.message((String)"rename.title"), null);
        return true;
    }

    public void performAutomaticRename(String newName, PsiElement elementToRename) {
        for (AutomaticRenamerFactory renamerFactory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
            if (!renamerFactory.isApplicable(elementToRename)) continue;
            final ArrayList usages = new ArrayList();
            final AutomaticRenamer renamer = renamerFactory.createRenamer(elementToRename, newName, new ArrayList<UsageInfo>());
            if (!renamer.hasAnythingToRename()) continue;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                AutomaticRenamingDialog renamingDialog = new AutomaticRenamingDialog(this.myProject, renamer);
                renamingDialog.show();
                if (!renamingDialog.isOK()) {
                    return;
                }
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    renamer.findUsages(usages, false, false);
                }
            };
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) {
                return;
            }
            final UsageInfo[] usageInfos = usages.toArray(new UsageInfo[usages.size()]);
            for (final PsiNamedElement element : renamer.getElements()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        String newElementName = renamer.getNewName(element);
                        if (newElementName != null) {
                            RenameUtil.doRenameGenericNamedElement((PsiElement)element, newElementName, RenameProcessor.extractUsagesForElement((PsiElement)element, usageInfos), null);
                        }
                    }
                });
            }
        }
    }

    private static VirtualFile getTopLevelVirtualFile(FileViewProvider fileViewProvider) {
        VirtualFile file = fileViewProvider.getVirtualFile();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCleared() {
        try {
            assert (ourRenamersStack.isEmpty()) : ourRenamersStack;
        }
        finally {
            ourRenamersStack.clear();
        }
    }

    public void finish() {
        if (!ourRenamersStack.isEmpty() && ourRenamersStack.peek() == this) {
            ourRenamersStack.pop();
        }
        if (this.myHighlighters != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighters = null;
        }
    }

    private void collectElementsToHighlight(Map<TextRange, TextAttributes> rangesToHighlight, Collection<PsiReference> refs) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        PsiElement nameId = this.myElementToRename.getNameIdentifier();
        LOG.assertTrue(nameId != null);
        rangesToHighlight.put(nameId.getTextRange().shiftRight(PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)nameId)), colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES));
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            TextRange range = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset() + PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)element));
            ReadWriteAccessDetector writeAccessDetector = ReadWriteAccessDetector.findDetector((PsiElement)element);
            boolean isForWrite = writeAccessDetector != null && ReadWriteAccessDetector.Access.Write == writeAccessDetector.getExpressionAccess(element);
            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(isForWrite ? EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES : EditorColors.SEARCH_RESULT_ATTRIBUTES);
            rangesToHighlight.put(range, attributes);
        }
    }

    private static void addHighlights(@NotNull Map<TextRange, TextAttributes> ranges, @NotNull Editor editor, @NotNull Collection<RangeHighlighter> highlighters, @NotNull HighlightManager highlightManager) {
        if (ranges == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenamer.addHighlights must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenamer.addHighlights must not be null");
        }
        if (highlighters == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenamer.addHighlights must not be null");
        }
        if (highlightManager == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenamer.addHighlights must not be null");
        }
        for (Map.Entry<TextRange, TextAttributes> entry : ranges.entrySet()) {
            TextRange range = entry.getKey();
            TextAttributes attributes = entry.getValue();
            highlightManager.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }

    private static PsiElement getSelectedInEditorElement(PsiElement nameIdentifier, Collection<PsiReference> refs, int offset) {
        TextRange range;
        if (nameIdentifier != null && VariableInplaceRenamer.contains(range = nameIdentifier.getTextRange(), offset)) {
            return nameIdentifier;
        }
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            TextRange range2 = element.getTextRange();
            if (!VariableInplaceRenamer.contains(range2, offset)) continue;
            return element;
        }
        LOG.assertTrue(false);
        return null;
    }

    private static boolean contains(TextRange range, int offset) {
        return range.getStartOffset() <= offset && offset <= range.getEndOffset();
    }

    private void addVariable(PsiReference reference, PsiElement selectedElement, TemplateBuilderImpl builder) {
        if (reference.getElement() == selectedElement) {
            MyExpression expression = new MyExpression(this.myElementToRename.getName());
            builder.replaceElement(reference, PRIMARY_VARIABLE_NAME, (Expression)expression, true);
        } else {
            builder.replaceElement(reference, OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
    }

    private void addVariable(PsiElement element, PsiElement selectedElement, TemplateBuilderImpl builder) {
        if (element == selectedElement) {
            MyExpression expression = new MyExpression(this.myElementToRename.getName());
            builder.replaceElement(element, PRIMARY_VARIABLE_NAME, (Expression)expression, true);
        } else {
            builder.replaceElement(element, OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
    }

    private class MyExpression
    extends Expression {
        private final String myName;
        private final LookupElement[] myLookupItems;

        private MyExpression(String name) {
            this.myName = name;
            ArrayList names = new ArrayList();
            for (NameSuggestionProvider provider : (NameSuggestionProvider[])Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME)) {
                provider.getSuggestedNames((PsiElement)VariableInplaceRenamer.this.myElementToRename, (PsiElement)VariableInplaceRenamer.this.myElementToRename, names);
            }
            this.myLookupItems = new LookupElement[names.size()];
            for (int i = 0; i < this.myLookupItems.length; ++i) {
                this.myLookupItems[i] = LookupElementBuilder.create((String)((String)names.get(i)));
            }
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return this.myLookupItems;
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myName);
        }

        public Result calculateResult(ExpressionContext context) {
            return new TextResult(this.myName);
        }
    }
}

