/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.removemiddleman;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.Set;

public class DelegationUtils {
    private DelegationUtils() {
    }

    public static Set<PsiMethod> getDelegatingMethodsForField(PsiField field) {
        PsiMethod[] methods;
        HashSet<PsiMethod> out = new HashSet<PsiMethod>();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return out;
        }
        for (PsiMethod method : methods = containingClass.getMethods()) {
            if (!DelegationUtils.isDelegation(field, method)) continue;
            out.add(method);
        }
        return out;
    }

    private static boolean isDelegation(PsiField field, PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (statement instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            if (!DelegationUtils.isDelegationCall(returnValue, field, method)) {
                return false;
            }
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpression value = ((PsiExpressionStatement)statement).getExpression();
            if (!DelegationUtils.isDelegationCall(value, field, method)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isAbstract(PsiMethod method) {
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        return method.getContainingClass().isInterface();
    }

    private static boolean isDelegationCall(PsiExpression expression, PsiField field, PsiMethod method) {
        PsiExpression[] args;
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement referent = ((PsiReference)qualifier).resolve();
        if (referent == null || !referent.equals(field)) {
            return false;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression arg : args = argumentList.getExpressions()) {
            if (DelegationUtils.isParameterReference(arg, method)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParameterReference(PsiExpression arg, PsiMethod method) {
        if (!(arg instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement referent = ((PsiReference)arg).resolve();
        if (!(referent instanceof PsiParameter)) {
            return false;
        }
        PsiElement declarationScope = ((PsiParameter)referent).getDeclarationScope();
        return method.equals(declarationScope);
    }

    public static int[] getParameterPermutation(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements[0];
        PsiParameterList parameterList = method.getParameterList();
        if (statement instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            return DelegationUtils.calculatePermutation(call, parameterList);
        }
        PsiExpression value = ((PsiExpressionStatement)statement).getExpression();
        PsiMethodCallExpression call = (PsiMethodCallExpression)value;
        return DelegationUtils.calculatePermutation(call, parameterList);
    }

    private static int[] calculatePermutation(PsiMethodCallExpression call, PsiParameterList parameterList) {
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        int[] out = ArrayUtil.newIntArray((int)args.length);
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = args[i];
            PsiParameter parameter = (PsiParameter)((PsiReference)arg).resolve();
            out[i] = parameterList.getParameterIndex(parameter);
        }
        return out;
    }

    public static PsiMethod getDelegatedMethod(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements[0];
        if (statement instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            assert (call != null);
            return call.resolveMethod();
        }
        PsiExpression value = ((PsiExpressionStatement)statement).getExpression();
        PsiMethodCallExpression call = (PsiMethodCallExpression)value;
        return call.resolveMethod();
    }
}

