/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.VisibilityPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.usageView.UsageViewUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class MoveInstanceMethodDialogBase
extends RefactoringDialog {
    protected final PsiMethod myMethod;
    protected final PsiVariable[] myVariables;
    protected JList myList;
    protected VisibilityPanel myVisibilityPanel;
    protected final String myRefactoringName;

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public MoveInstanceMethodDialogBase(PsiMethod method, PsiVariable[] variables, String refactoringName) {
        super(method.getProject(), true);
        this.myMethod = method;
        this.myVariables = variables;
        this.myRefactoringName = refactoringName;
        this.setTitle(this.myRefactoringName);
    }

    protected JPanel createListAndVisibilityPanels() {
        this.myList = this.createTargetVariableChooser();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myList);
        JPanel hBox = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridheight = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        hBox.add((Component)scrollPane, gbConstraints);
        hBox.add(Box.createHorizontalStrut(4));
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 3;
        ++gbConstraints.gridx;
        this.myVisibilityPanel = MoveInstanceMethodDialogBase.createVisibilityPanel();
        hBox.add((Component)this.myVisibilityPanel, gbConstraints);
        return hBox;
    }

    protected JList createTargetVariableChooser() {
        final JList<Object> list = new JList<Object>(new MyListModel());
        list.setCellRenderer(new MyListCellRenderer());
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MoveInstanceMethodDialogBase.this.getOKAction().setEnabled(!list.getSelectionModel().isSelectionEmpty());
            }
        });
        return list;
    }

    protected static VisibilityPanel createVisibilityPanel() {
        VisibilityPanel visibilityPanel = new VisibilityPanel(false, true);
        visibilityPanel.setVisibility(null);
        return visibilityPanel;
    }

    protected boolean verifyTargetClass(PsiClass targetClass) {
        if (targetClass.isInterface()) {
            Project project = this.getProject();
            if (ClassInheritorsSearch.search((PsiClass)targetClass, (SearchScope)targetClass.getUseScope(), (boolean)false).findFirst() == null) {
                String message = RefactoringBundle.message((String)"0.is.an.interface.that.has.no.implementing.classes", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)targetClass)});
                Messages.showErrorDialog((Project)project, (String)message, (String)this.myRefactoringName);
                return false;
            }
            String message = RefactoringBundle.message((String)"0.is.an.interface.method.implementation.will.be.added.to.all.directly.implementing.classes", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)targetClass)});
            int result = Messages.showYesNoDialog((Project)project, (String)message, (String)this.myRefactoringName, (Icon)Messages.getQuestionIcon());
            if (result != 0) {
                return false;
            }
        }
        return true;
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PsiVariable psiVariable = (PsiVariable)value;
            String text = PsiFormatUtil.formatVariable((PsiVariable)psiVariable, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            this.setIcon(psiVariable.getIcon(0));
            this.setText(text);
            return this;
        }
    }

    private class MyListModel
    extends AbstractListModel {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return MoveInstanceMethodDialogBase.this.myVariables.length;
        }

        @Override
        public Object getElementAt(int index) {
            return MoveInstanceMethodDialogBase.this.myVariables[index];
        }
    }
}

