/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesToNewDirectoryDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesToNewDirectoryDialog");
    private final PsiDirectory myDirectory;
    private final PsiElement[] myElementsToMove;
    private final MoveCallback myMoveCallback;
    private TextFieldWithBrowseButton myDestDirectoryField;
    private JCheckBox mySearchForTextOccurrencesCheckBox;
    private JCheckBox mySearchInCommentsAndStringsCheckBox;
    private JPanel myRootPanel;
    private JLabel myNameLabel;
    private JCheckBox myPreserveSourceRoot;

    public MoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, PsiElement[] elementsToMove, MoveCallback moveCallback) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesToNewDirectoryDialog.<init> must not be null");
        }
        this(directory, elementsToMove, true, moveCallback);
    }

    public MoveClassesOrPackagesToNewDirectoryDialog(final @NotNull PsiDirectory directory, PsiElement[] elementsToMove, boolean canShowPreserveSourceRoots, MoveCallback moveCallback) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesToNewDirectoryDialog.<init> must not be null");
        }
        super(false);
        this.$$$setupUI$$$();
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.myDirectory = directory;
        this.myElementsToMove = elementsToMove;
        this.myMoveCallback = moveCallback;
        this.myDestDirectoryField.setText(FileUtil.toSystemDependentName((String)directory.getVirtualFile().getPath()));
        final FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.myDestDirectoryField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile[] files = FileChooser.chooseFiles((Project)MoveClassesOrPackagesToNewDirectoryDialog.this.myDirectory.getProject(), (FileChooserDescriptor)descriptor, (VirtualFile)directory.getVirtualFile());
                if (files.length == 1) {
                    MoveClassesOrPackagesToNewDirectoryDialog.this.myDestDirectoryField.setText(FileUtil.toSystemDependentName((String)files[0].getPath()));
                }
            }
        });
        if (elementsToMove.length == 1) {
            PsiElement firstElement = elementsToMove[0];
            this.myNameLabel.setText(RefactoringBundle.message((String)"move.single.class.or.package.name.label", (Object[])new Object[]{UsageViewUtil.getType(firstElement), UsageViewUtil.getLongName(firstElement)}));
        } else if (elementsToMove.length > 1) {
            this.myNameLabel.setText(elementsToMove[0] instanceof PsiClass ? RefactoringBundle.message((String)"move.specified.classes") : RefactoringBundle.message((String)"move.specified.packages"));
        }
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        this.mySearchInCommentsAndStringsCheckBox.setSelected(refactoringSettings.MOVE_SEARCH_IN_COMMENTS);
        this.mySearchForTextOccurrencesCheckBox.setSelected(refactoringSettings.MOVE_SEARCH_FOR_TEXT);
        this.myDestDirectoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                MoveClassesOrPackagesToNewDirectoryDialog.this.setOKActionEnabled(MoveClassesOrPackagesToNewDirectoryDialog.this.myDestDirectoryField.getText().length() > 0);
            }
        });
        if (canShowPreserveSourceRoots) {
            HashSet<VirtualFile> sourceRoots = new HashSet<VirtualFile>();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex();
            for (PsiElement element : elementsToMove) {
                if (element instanceof PsiPackage) {
                    for (PsiDirectory psiDirectory : ((PsiPackage)element).getDirectories()) {
                        sourceRoots.add(fileIndex.getSourceRootForFile(psiDirectory.getVirtualFile()));
                    }
                    continue;
                }
                if (!(element instanceof PsiClass)) continue;
                PsiDirectory psiDirectory = element.getContainingFile().getContainingDirectory();
                LOG.assertTrue(psiDirectory != null);
                if (psiDirectory == null) continue;
                sourceRoots.add(psiDirectory.getVirtualFile());
            }
            this.myPreserveSourceRoot.setVisible(sourceRoots.size() > 1);
        }
        this.init();
    }

    private boolean isSearchInNonJavaFiles() {
        return this.mySearchForTextOccurrencesCheckBox.isSelected();
    }

    private boolean isSearchInComments() {
        return this.mySearchInCommentsAndStringsCheckBox.isSelected();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    protected void doOKAction() {
        final String path = FileUtil.toSystemIndependentName((String)this.myDestDirectoryField.getText());
        final Project project = this.myDirectory.getProject();
        PsiDirectory directory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

            public PsiDirectory compute() {
                try {
                    return DirectoryUtil.mkdirs(PsiManager.getInstance((Project)project), path);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        });
        if (directory == null) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"cannot.find.or.create.destination.directory"), (String)RefactoringBundle.message((String)"cannot.move"));
            return;
        }
        super.doOKAction();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"destination.directory.does.not.correspond.to.any.package"), (String)RefactoringBundle.message((String)"cannot.move"));
            return;
        }
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        boolean searchInComments = this.isSearchInComments();
        boolean searchForTextOccurences = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = searchInComments;
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = searchForTextOccurences;
        this.performRefactoring(project, directory, aPackage, searchInComments, searchForTextOccurences);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDestDirectoryField.getTextField();
    }

    protected void performRefactoring(Project project, PsiDirectory directory, PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurences) {
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
        if (sourceRoot == null) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"destination.directory.does.not.correspond.to.any.package"), (String)RefactoringBundle.message((String)"cannot.move"));
            return;
        }
        JavaRefactoringFactory factory = JavaRefactoringFactory.getInstance((Project)project);
        MoveDestination destination = this.myPreserveSourceRoot.isSelected() && this.myPreserveSourceRoot.isVisible() ? factory.createSourceFolderPreservingMoveDestination(aPackage.getQualifiedName()) : factory.createSourceRootMoveDestination(aPackage.getQualifiedName(), sourceRoot);
        MoveClassesOrPackagesProcessor processor = new MoveClassesOrPackagesProcessor(this.myDirectory.getProject(), this.myElementsToMove, destination, searchInComments, searchForTextOccurences, this.myMoveCallback);
        if (processor.verifyValidPackageName()) {
            processor.run();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox3;
        JLabel jLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.specified.classes.to"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySearchInCommentsAndStringsCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDestDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(400, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("To directory:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySearchForTextOccurrencesCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreserveSourceRoot = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Don't move to another source folder");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

