/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractclass.BackpointerUtil;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

class ExtractedClassBuilder {
    private static final Logger LOGGER = Logger.getInstance((String)"com.siyeh.rpp.extractclass.ExtractedClassBuilder");
    private String className = null;
    private String packageName = null;
    private final List<PsiField> fields = new ArrayList<PsiField>(5);
    private final List<PsiMethod> methods = new ArrayList<PsiMethod>(5);
    private final List<PsiClassInitializer> initializers = new ArrayList<PsiClassInitializer>(5);
    private final List<PsiClass> innerClasses = new ArrayList<PsiClass>(5);
    private final List<PsiClass> innerClassesToMakePublic = new ArrayList<PsiClass>(5);
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private final List<PsiClass> interfaces = new ArrayList<PsiClass>();
    private boolean requiresBackPointer = false;
    private String originalClassName = null;
    private String backPointerName = null;
    private Project myProject;
    private JavaCodeStyleManager myJavaCodeStyleManager;
    private Set<PsiField> myFieldsNeedingSetters;
    private Set<PsiField> myFieldsNeedingGetter;

    ExtractedClassBuilder() {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOriginalClassName(String originalClassName) {
        this.originalClassName = originalClassName;
    }

    public void addField(PsiField field) {
        this.fields.add(field);
    }

    public void addMethod(PsiMethod method) {
        this.methods.add(method);
    }

    public void addInitializer(PsiClassInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addInnerClass(PsiClass innerClass, boolean makePublic) {
        this.innerClasses.add(innerClass);
        if (makePublic) {
            this.innerClassesToMakePublic.add(innerClass);
        }
    }

    public void setTypeArguments(List<PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setInterfaces(List<PsiClass> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
    }

    public String buildBeanClass() {
        boolean first;
        if (this.requiresBackPointer) {
            this.calculateBackpointerName();
        }
        StringBuffer out = new StringBuffer(1024);
        if (this.packageName.length() > 0) {
            out.append("package " + this.packageName + ';');
        }
        out.append("public ");
        if (this.hasAbstractMethod()) {
            out.append("abstract ");
        }
        out.append("class ");
        out.append(this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                out.append(typeParam.getText());
                first = false;
            }
            out.append('>');
        }
        if (!this.interfaces.isEmpty()) {
            out.append(" implements ");
            first = true;
            for (PsiClass implemented : this.interfaces) {
                if (!first) {
                    out.append(',');
                }
                out.append(implemented.getQualifiedName());
                first = false;
            }
        }
        out.append('{');
        if (this.requiresBackPointer) {
            out.append("private final " + this.originalClassName);
            if (!this.typeParams.isEmpty()) {
                out.append('<');
                first = true;
                for (PsiTypeParameter typeParam : this.typeParams) {
                    if (!first) {
                        out.append(',');
                    }
                    out.append(typeParam.getName());
                    first = false;
                }
                out.append('>');
            }
            out.append(' ' + this.backPointerName + ";");
        }
        this.outputFieldsAndInitializers(out);
        if (this.needConstructor() || this.requiresBackPointer) {
            this.outputConstructor(out);
        }
        this.outputMethods(out);
        this.outputInnerClasses(out);
        out.append("}");
        return out.toString();
    }

    private boolean hasAbstractMethod() {
        for (PsiMethod method : this.methods) {
            if (!method.hasModifierProperty("abstract")) continue;
            return true;
        }
        return false;
    }

    private void calculateBackpointerName() {
        String baseName;
        if (this.originalClassName.indexOf(46) == 0) {
            baseName = StringUtil.decapitalize((String)this.originalClassName);
        } else {
            String simpleClassName = this.originalClassName.substring(this.originalClassName.lastIndexOf(46) + 1);
            baseName = StringUtil.decapitalize((String)simpleClassName);
        }
        String name = this.myJavaCodeStyleManager.propertyNameToVariableName(baseName, VariableKind.FIELD);
        if (!this.existsFieldWithName(name)) {
            this.backPointerName = name;
            return;
        }
        int counter = 1;
        while (true) {
            if (!this.existsFieldWithName(name = name + counter)) {
                this.backPointerName = name;
                return;
            }
            ++counter;
        }
    }

    private boolean existsFieldWithName(String name) {
        for (PsiField field : this.fields) {
            String fieldName = field.getName();
            if (!name.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean needConstructor() {
        for (PsiField field : this.fields) {
            if (field.hasModifierProperty("static")) continue;
            return true;
        }
        for (PsiMethod method : this.methods) {
            if (method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    private void outputMethods(StringBuffer out) {
        for (PsiMethod method : this.methods) {
            this.outputMutatedMethod(out, method);
        }
    }

    private void outputInnerClasses(StringBuffer out) {
        for (PsiClass innerClass : this.innerClasses) {
            this.outputMutatedInnerClass(out, innerClass, this.innerClassesToMakePublic.contains(innerClass));
        }
    }

    private void outputMutatedInitializer(StringBuffer out, PsiClassInitializer initializer) {
        Mutator visitor = new Mutator(out);
        initializer.accept((PsiElementVisitor)visitor);
    }

    private void outputMutatedMethod(StringBuffer out, PsiMethod method) {
        Mutator visitor = new Mutator(out);
        method.accept((PsiElementVisitor)visitor);
    }

    private void outputMutatedInnerClass(StringBuffer out, PsiClass innerClass, boolean makePublic) {
        if (makePublic) {
            try {
                PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"public", (boolean)false);
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
            }
        }
        Mutator visitor = new Mutator(out);
        innerClass.accept((PsiElementVisitor)visitor);
    }

    private void outputFieldsAndInitializers(StringBuffer out) {
        ArrayList<PsiClassInitializer> remainingInitializers = new ArrayList<PsiClassInitializer>(this.initializers);
        for (PsiField field : this.fields) {
            Iterator initializersIterator = remainingInitializers.iterator();
            int fieldOffset = field.getTextRange().getStartOffset();
            while (initializersIterator.hasNext()) {
                PsiClassInitializer initializer = (PsiClassInitializer)initializersIterator.next();
                if (initializer.getTextRange().getStartOffset() >= fieldOffset) continue;
                this.outputMutatedInitializer(out, initializer);
                initializersIterator.remove();
            }
            this.outputField(field, out);
            if (this.myFieldsNeedingGetter != null && this.myFieldsNeedingGetter.contains(field)) {
                out.append(PropertyUtil.generateGetterPrototype((PsiField)field).getText());
                out.append("\n");
            }
            if (this.myFieldsNeedingSetters == null || !this.myFieldsNeedingSetters.contains(field)) continue;
            out.append(PropertyUtil.generateSetterPrototype((PsiField)field).getText());
            out.append("\n");
        }
        for (PsiClassInitializer initializer : remainingInitializers) {
            this.outputMutatedInitializer(out, initializer);
        }
    }

    private String calculateStrippedName(PsiVariable variable) {
        String name = variable.getName();
        if (name == null) {
            return null;
        }
        if (variable instanceof PsiField) {
            name = this.myJavaCodeStyleManager.variableNameToPropertyName(name, variable.hasModifierProperty("static") ? VariableKind.STATIC_FIELD : VariableKind.FIELD);
        }
        return name;
    }

    private void outputConstructor(@NonNls StringBuffer out) {
        String parameterName;
        out.append("\tpublic " + this.className + '(');
        if (this.requiresBackPointer) {
            parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(this.backPointerName, VariableKind.PARAMETER);
            out.append(this.originalClassName);
            if (!this.typeParams.isEmpty()) {
                out.append('<');
                boolean first = true;
                for (PsiTypeParameter typeParam : this.typeParams) {
                    if (!first) {
                        out.append(',');
                    }
                    out.append(typeParam.getName());
                    first = false;
                }
                out.append('>');
            }
            out.append(' ' + parameterName);
        }
        out.append(")");
        out.append("\t{");
        if (this.requiresBackPointer) {
            parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(this.backPointerName, VariableKind.PARAMETER);
            if (this.backPointerName.equals(parameterName)) {
                out.append("\t\tthis." + this.backPointerName + " = " + parameterName + ";");
            } else {
                out.append("\t\t" + this.backPointerName + " = " + parameterName + ";");
            }
        }
        out.append("\t}");
    }

    private void outputField(PsiField field, @NonNls StringBuffer out) {
        field.accept((PsiElementVisitor)new Mutator(out));
    }

    public void setRequiresBackPointer(boolean requiresBackPointer) {
        this.requiresBackPointer = requiresBackPointer;
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
    }

    public void setFieldsNeedingGetters(Set<PsiField> fieldsNeedingGetter) {
        this.myFieldsNeedingGetter = fieldsNeedingGetter;
    }

    public void setFieldsNeedingSetters(Set<PsiField> fieldsNeedingSetters) {
        this.myFieldsNeedingSetters = fieldsNeedingSetters;
    }

    private boolean fieldIsExtracted(PsiField field) {
        for (PsiField psiField : this.fields) {
            if (!psiField.equals(field)) continue;
            return true;
        }
        PsiClass containingClass = field.getContainingClass();
        return this.innerClasses.contains(containingClass);
    }

    private class Mutator
    extends JavaElementVisitor {
        @NonNls
        private final StringBuffer out;

        private Mutator(StringBuffer out) {
            this.out = out;
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            PsiElement[] children = element.getChildren();
            if (children.length == 0) {
                String text = element.getText();
                this.out.append(text);
            } else {
                for (PsiElement child : children) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                PsiElement referent = expression.resolve();
                if (referent instanceof PsiField) {
                    PsiField field = (PsiField)referent;
                    if (ExtractedClassBuilder.this.fieldIsExtracted(field)) {
                        String name = field.getName();
                        if (qualifier != null && name.equals(expression.getReferenceName())) {
                            this.out.append("this.");
                        }
                        this.out.append(name);
                    } else if (field.hasModifierProperty("static")) {
                        this.out.append(ExtractedClassBuilder.this.originalClassName + '.' + field.getName());
                    } else {
                        this.out.append(ExtractedClassBuilder.this.backPointerName + '.' + PropertyUtil.suggestGetterName((Project)field.getProject(), (PsiField)field) + "()");
                    }
                } else {
                    this.visitElement((PsiElement)expression);
                }
            } else {
                this.visitElement((PsiElement)expression);
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = expression.getRExpression();
            if (this.isBackpointerReference(lhs) && rhs != null) {
                while (lhs instanceof PsiParenthesizedExpression) {
                    lhs = ((PsiParenthesizedExpression)lhs).getExpression();
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
                assert (reference != null);
                PsiField field = (PsiField)reference.resolve();
                PsiJavaToken sign = expression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                assert (field != null);
                if (!field.hasModifierProperty("static")) {
                    this.delegate(rhs, field, sign, tokenType, ExtractedClassBuilder.this.backPointerName);
                } else {
                    this.visitElement((PsiElement)expression);
                }
            } else {
                this.visitElement((PsiElement)expression);
            }
        }

        private void delegate(PsiExpression rhs, PsiField field, PsiJavaToken sign, IElementType tokenType, String fieldName) {
            if (tokenType.equals(JavaTokenType.EQ)) {
                String setterName = PropertyUtil.suggestSetterName((Project)field.getProject(), (PsiField)field);
                this.out.append(fieldName + '.' + setterName + '(');
                rhs.accept((PsiElementVisitor)this);
                this.out.append(')');
            } else {
                String operator = sign.getText().substring(0, sign.getTextLength() - 1);
                String setterName = PropertyUtil.suggestSetterName((Project)field.getProject(), (PsiField)field);
                this.out.append(fieldName + '.' + setterName + '(');
                String getterName = PropertyUtil.suggestGetterName((Project)field.getProject(), (PsiField)field);
                this.out.append(fieldName + '.' + getterName + "()");
                this.out.append(operator);
                rhs.accept((PsiElementVisitor)this);
                this.out.append(')');
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            this.outputUnaryExpression((PsiExpression)expression, expression.getOperand(), expression.getOperationSign());
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            this.outputUnaryExpression((PsiExpression)expression, expression.getOperand(), expression.getOperationSign());
        }

        private void outputUnaryExpression(PsiExpression expression, PsiExpression operand, PsiJavaToken sign) {
            IElementType tokenType = sign.getTokenType();
            if (this.isBackpointerReference(operand) && (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS))) {
                while (operand instanceof PsiParenthesizedExpression) {
                    operand = ((PsiParenthesizedExpression)operand).getExpression();
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)operand;
                String operator = tokenType.equals(JavaTokenType.PLUSPLUS) ? "+" : "-";
                PsiField field = (PsiField)reference.resolve();
                assert (field != null);
                if (!field.hasModifierProperty("static")) {
                    this.out.append(ExtractedClassBuilder.this.backPointerName + '.' + PropertyUtil.suggestSetterName((Project)field.getProject(), (PsiField)field) + '(' + ExtractedClassBuilder.this.backPointerName + '.' + PropertyUtil.suggestGetterName((Project)field.getProject(), (PsiField)field) + "()" + operator + "1)");
                } else {
                    this.visitElement((PsiElement)expression);
                }
            } else {
                this.visitElement((PsiElement)expression);
            }
        }

        private boolean isBackpointerReference(PsiExpression expression) {
            return BackpointerUtil.isBackpointerReference(expression, new Condition<PsiField>(){

                public boolean value(PsiField psiField) {
                    return !ExtractedClassBuilder.this.fieldIsExtracted(psiField);
                }
            });
        }

        public void visitThisExpression(PsiThisExpression expression) {
            this.out.append(ExtractedClassBuilder.this.backPointerName);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiReferenceExpression expression = call.getMethodExpression();
            PsiElement qualifier = expression.getQualifier();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                PsiMethod method = call.resolveMethod();
                if (method != null && !this.isCompletelyMoved(method)) {
                    String methodName = method.getName();
                    if (method.hasModifierProperty("static")) {
                        this.out.append(ExtractedClassBuilder.this.originalClassName + '.' + methodName);
                    } else {
                        this.out.append(ExtractedClassBuilder.this.backPointerName + '.' + methodName);
                    }
                    PsiExpressionList argumentList = call.getArgumentList();
                    argumentList.accept((PsiElementVisitor)this);
                } else {
                    this.visitElement((PsiElement)call);
                }
            } else {
                this.visitElement((PsiElement)call);
            }
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String referenceText = reference.getCanonicalText();
            this.out.append(referenceText);
        }

        private boolean isCompletelyMoved(PsiMethod method) {
            return ExtractedClassBuilder.this.methods.contains(method) && !MethodInheritanceUtils.hasSiblingMethods(method);
        }
    }
}

