/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ExtractInterfaceDialog
extends ExtractSuperBaseDialog {
    private JLabel myInterfaceNameLabel;
    private JLabel myPackageLabel;

    public ExtractInterfaceDialog(Project project, PsiClass sourceClass) {
        super(project, sourceClass, ExtractInterfaceDialog.collectMembers(sourceClass), ExtractInterfaceHandler.REFACTORING_NAME);
        this.init();
    }

    private static List<MemberInfo> collectMembers(PsiClass c) {
        return MemberInfo.extractClassMembers(c, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                if (element instanceof PsiMethod) {
                    return element.hasModifierProperty("public") && !element.hasModifierProperty("static");
                }
                if (element instanceof PsiField) {
                    return element.hasModifierProperty("final") && element.hasModifierProperty("static") && element.hasModifierProperty("public");
                }
                if (element instanceof PsiClass) {
                    return ((PsiClass)element).isInterface() || element.hasModifierProperty("static");
                }
                return false;
            }
        }, true);
    }

    public MemberInfo[] getSelectedMembers() {
        int[] rows = this.getCheckedRows();
        MemberInfo[] selectedMethods = new MemberInfo[rows.length];
        for (int idx = 0; idx < rows.length; ++idx) {
            selectedMethods[idx] = (MemberInfo)((Object)this.myMemberInfos.get(rows[idx]));
        }
        return selectedMethods;
    }

    private int[] getCheckedRows() {
        int count = 0;
        for (MemberInfo info : this.myMemberInfos) {
            if (!info.isChecked()) continue;
            ++count;
        }
        int[] rows = new int[count];
        int currentRow = 0;
        for (int idx = 0; idx < this.myMemberInfos.size(); ++idx) {
            if (!((MemberInfo)((Object)this.myMemberInfos.get(idx))).isChecked()) continue;
            rows[currentRow++] = idx;
        }
        return rows;
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(RefactoringBundle.message((String)"extract.interface.from")), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        box.add(this.createActionComponent());
        box.add(Box.createVerticalStrut(10));
        this.myInterfaceNameLabel = new JLabel();
        this.myInterfaceNameLabel.setText(RefactoringBundle.message((String)"interface.name.prompt"));
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myInterfaceNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(5));
        _panel = new JPanel(new BorderLayout());
        this.myPackageLabel = new JLabel();
        this.myPackageLabel.setText(RefactoringBundle.message((String)"package.for.new.interface"));
        _panel.add((Component)this.myPackageLabel, "North");
        _panel.add((Component)((Object)this.myPackageNameField), "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected void updateDialogForExtractSubclass() {
        super.updateDialogForExtractSubclass();
        this.myInterfaceNameLabel.setText(RefactoringBundle.message((String)"rename.implementation.class.to"));
    }

    @Override
    protected void updateDialogForExtractSuperclass() {
        super.updateDialogForExtractSuperclass();
        this.myInterfaceNameLabel.setText(RefactoringBundle.message((String)"interface.name.prompt"));
    }

    @Override
    protected String getClassNameLabelText() {
        return RefactoringBundle.message((String)"superinterface.name");
    }

    @Override
    protected JLabel getClassNameLabel() {
        return this.myInterfaceNameLabel;
    }

    @Override
    protected JLabel getPackageNameLabel() {
        return this.myPackageLabel;
    }

    @Override
    protected String getEntityName() {
        return RefactoringBundle.message((String)"extractSuperInterface.interface");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.interface"), this.myMemberInfos, null);
        memberSelectionPanel.getTable().setMemberInfoModel(new DelegatingMemberInfoModel<PsiMember, MemberInfo>(memberSelectionPanel.getTable().getMemberInfoModel()){

            @Override
            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }
        });
        panel.add((Component)memberSelectionPanel, "Center");
        panel.add((Component)this.myJavaDocPanel, "East");
        return panel;
    }

    @Override
    protected String getJavaDocPanelName() {
        return RefactoringBundle.message((String)"extractSuperInterface.javadoc");
    }

    @Override
    protected String getExtractedSuperNameNotSpecifiedKey() {
        return RefactoringBundle.message((String)"no.interface.name.specified");
    }

    @Override
    protected int getJavaDocPolicySetting() {
        return JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_JAVADOC;
    }

    @Override
    protected void setJavaDocPolicySetting(int policy) {
        JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_JAVADOC = policy;
    }

    @Override
    protected ExtractSuperBaseProcessor createProcessor() {
        return new ExtractInterfaceProcessor(this.myProject, false, this.getTargetDirectory(), this.getExtractedSuperName(), this.mySourceClass, this.getSelectedMembers(), new DocCommentPolicy(this.getJavaDocPolicy()));
    }

    @Override
    protected String getHelpId() {
        return "refactoring.extractInterface";
    }
}

