/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureTargetUtil;

public class ChangeSignatureAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && (elements[0] instanceof PsiMethod || elements[0] instanceof PsiClass);
    }

    @Override
    protected boolean isAvailableOnElementInEditor(PsiElement element, Editor editor) {
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)element.getProject()).getPsiFile(document);
        if (file != null && ChangeSignatureTargetUtil.findTargetMember(file, editor) != null) {
            return true;
        }
        return element instanceof PsiMethod || element instanceof PsiClass;
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        return new ChangeSignatureHandler();
    }
}

