/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ParameterListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.ParameterListElement");

    public ParameterListElement() {
        super(PARAMETER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (first == last && first.getElementType() == PARAMETER) {
            LeafElement comma;
            ASTNode child;
            TreeElement element = first;
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            for (child = element.getTreeNext(); child != null && child.getElementType() != COMMA; child = child.getTreeNext()) {
                if (child.getElementType() != PARAMETER) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, element, Boolean.FALSE);
                break;
            }
            for (child = element.getTreePrev(); child != null && child.getElementType() != COMMA; child = child.getTreePrev()) {
                if (child.getElementType() != PARAMETER) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        try {
            CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/ParameterListElement.deleteChildInternal must not be null");
        }
        if (child.getElementType() == PARAMETER) {
            ASTNode next = TreeUtil.skipElements(child.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET);
            if (next != null && next.getElementType() == COMMA) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = TreeUtil.skipElementsBack(child.getTreePrev(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET);
                if (prev != null && prev.getElementType() == COMMA) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
        try {
            CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                if (this.getFirstChildNode().getElementType() == LPARENTH) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 25: 
        }
        if (this.getLastChildNode().getElementType() == RPARENTH) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return this.getChildRole(child, 24);
        }
        if (i == RPARENTH) {
            return this.getChildRole(child, 25);
        }
        return 0;
    }
}

