/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.containers.HashMap;

public class ModifierListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.ModifierListElement");
    private static final HashMap<String, Integer> ourModifierToOrderMap = new HashMap();

    public ModifierListElement() {
        super(Constants.MODIFIER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (before == null && first == last && ElementType.KEYWORD_BIT_SET.contains(first.getElementType())) {
            anchor = ModifierListElement.getDefaultAnchor((PsiModifierList)SourceTreeToPsiMap.treeElementToPsi(this), (PsiKeyword)SourceTreeToPsiMap.treeElementToPsi(first));
            before = Boolean.TRUE;
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (child.getElementType() == JavaElementType.ANNOTATION) {
            return 250;
        }
        return 0;
    }

    private static ASTNode getDefaultAnchor(PsiModifierList modifierList, PsiKeyword modifier) {
        Integer order = (Integer)ourModifierToOrderMap.get((Object)modifier.getText());
        if (order == null) {
            return null;
        }
        for (ASTNode child = SourceTreeToPsiMap.psiElementToTree((PsiElement)modifierList).getFirstChildNode(); child != null; child = child.getTreeNext()) {
            Integer order1;
            if (!ElementType.KEYWORD_BIT_SET.contains(child.getElementType()) || (order1 = (Integer)ourModifierToOrderMap.get((Object)child.getText())) == null || order1 <= order) continue;
            return child;
        }
        return null;
    }

    static {
        ourModifierToOrderMap.put((Object)"public", (Object)1);
        ourModifierToOrderMap.put((Object)"private", (Object)1);
        ourModifierToOrderMap.put((Object)"protected", (Object)1);
        ourModifierToOrderMap.put((Object)"static", (Object)2);
        ourModifierToOrderMap.put((Object)"abstract", (Object)2);
        ourModifierToOrderMap.put((Object)"final", (Object)3);
        ourModifierToOrderMap.put((Object)"synchronized", (Object)4);
        ourModifierToOrderMap.put((Object)"transient", (Object)4);
        ourModifierToOrderMap.put((Object)"volatile", (Object)4);
        ourModifierToOrderMap.put((Object)"native", (Object)5);
        ourModifierToOrderMap.put((Object)"strictfp", (Object)6);
    }
}

