/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    public PsiLiteralExpression handleContentChange(PsiLiteralExpression expr, TextRange range, String newContent) throws IncorrectOperationException {
        if (!(expr.getValue() instanceof String)) {
            throw new IncorrectOperationException("cannot handle content change");
        }
        String oldText = expr.getText();
        newContent = StringUtil.escapeStringCharacters((String)newContent);
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace((PsiElement)newExpr);
    }

    public TextRange getRangeInElement(PsiLiteralExpression element) {
        return StringLiteralManipulator.getValueRange(element);
    }

    public static TextRange getValueRange(PsiLiteralExpression element) {
        Object value = element.getValue();
        if (!(value instanceof String) && !(value instanceof Character)) {
            return TextRange.from((int)0, (int)element.getTextLength());
        }
        return new TextRange(1, Math.max(1, element.getTextLength() - 1));
    }
}

