/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.NameDesc;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;

public class JDMethodComment
extends JDComment {
    private String returnTag;
    private ArrayList<NameDesc> parmsList;
    private ArrayList<NameDesc> throwsList;
    @NonNls
    private static final String PARAM_TAG = "@param ";
    @NonNls
    private static final String THROWS_TAG = "@throws ";
    @NonNls
    private static final String EXCEPTION_TAG = "@exception ";

    public JDMethodComment(CommentFormatter formatter) {
        super(formatter);
    }

    private void generateList(String prefix, StringBuffer sb, ArrayList<NameDesc> list, String tag, boolean align_comments, int min_name_length, int max_name_length, boolean generate_empty_tags) {
        int max = 0;
        if (align_comments) {
            Iterator<NameDesc> i$ = list.iterator();
            while (i$.hasNext()) {
                NameDesc aList;
                NameDesc nd = aList = i$.next();
                int l = nd.name.length();
                if (JDMethodComment.isNull(nd.desc) && !generate_empty_tags || l <= max || l > max_name_length) continue;
                max = l;
            }
        }
        max = Math.max(max, min_name_length);
        StringBuffer fill = new StringBuffer(prefix.length() + tag.length() + max + 1);
        fill.append(prefix);
        int k = max + 1 + tag.length();
        for (int i = 0; i < k; ++i) {
            fill.append(' ');
        }
        Iterator<NameDesc> i$ = list.iterator();
        while (i$.hasNext()) {
            NameDesc aList1;
            NameDesc nd = aList1 = i$.next();
            if (JDMethodComment.isNull(nd.desc) && !generate_empty_tags) continue;
            if (align_comments) {
                sb.append(prefix);
                sb.append(tag);
                sb.append(nd.name);
                if (nd.name.length() > max_name_length) {
                    sb.append('\n');
                    sb.append(this.myFormatter.getParser().splitIntoCLines(nd.desc, fill, true));
                    continue;
                }
                int len = max - nd.name.length() + 1;
                for (int j = 0; j < len; ++j) {
                    sb.append(' ');
                }
                sb.append(this.myFormatter.getParser().splitIntoCLines(nd.desc, fill, false));
                continue;
            }
            sb.append(this.myFormatter.getParser().splitIntoCLines(tag + nd.name + " " + nd.desc, prefix, true));
        }
    }

    @Override
    protected void generateSpecial(String prefix, @NonNls StringBuffer sb) {
        if (this.parmsList != null) {
            int before = sb.length();
            this.generateList(prefix, sb, this.parmsList, PARAM_TAG, this.myFormatter.getSettings().JD_ALIGN_PARAM_COMMENTS, this.myFormatter.getSettings().JD_MIN_PARM_NAME_LENGTH, this.myFormatter.getSettings().JD_MAX_PARM_NAME_LENGTH, this.myFormatter.getSettings().JD_KEEP_EMPTY_PARAMETER);
            int size = sb.length() - before;
            if (size > 0 && this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_PARM_COMMENTS) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        if (this.returnTag != null && (this.returnTag.trim().length() != 0 || this.myFormatter.getSettings().JD_KEEP_EMPTY_RETURN)) {
            sb.append(prefix);
            sb.append("@return ");
            sb.append(this.myFormatter.getParser().splitIntoCLines(this.returnTag, prefix + "        ", false));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_RETURN) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        if (this.throwsList != null) {
            String tag = this.myFormatter.getSettings().JD_USE_THROWS_NOT_EXCEPTION ? THROWS_TAG : EXCEPTION_TAG;
            this.generateList(prefix, sb, this.throwsList, tag, this.myFormatter.getSettings().JD_ALIGN_EXCEPTION_COMMENTS, this.myFormatter.getSettings().JD_MIN_EXCEPTION_NAME_LENGTH, this.myFormatter.getSettings().JD_MAX_EXCEPTION_NAME_LENGTH, this.myFormatter.getSettings().JD_KEEP_EMPTY_EXCEPTION);
        }
    }

    public String getReturnTag() {
        return this.returnTag;
    }

    public void setReturnTag(String returnTag) {
        this.returnTag = returnTag;
    }

    public NameDesc getParameter(String name) {
        return JDMethodComment.getNameDesc(name, this.parmsList);
    }

    public void removeParameter(NameDesc nd) {
        if (this.parmsList == null) {
            return;
        }
        this.parmsList.remove(nd);
    }

    public void removeThrow(NameDesc nd) {
        if (this.throwsList == null) {
            return;
        }
        this.throwsList.remove(nd);
    }

    private static NameDesc getNameDesc(String name, ArrayList<NameDesc> list) {
        if (list == null) {
            return null;
        }
        Iterator<NameDesc> i$ = list.iterator();
        while (i$.hasNext()) {
            NameDesc aList;
            NameDesc parameter = aList = i$.next();
            if (!parameter.name.equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public ArrayList<NameDesc> getParmsList() {
        return this.parmsList;
    }

    public void addParameter(String name, String description) {
        if (this.parmsList == null) {
            this.parmsList = new ArrayList();
        }
        this.parmsList.add(new NameDesc(name, description));
    }

    public ArrayList<NameDesc> getThrowsList() {
        return this.throwsList;
    }

    public void addThrow(String className, String description) {
        if (this.throwsList == null) {
            this.throwsList = new ArrayList();
        }
        this.throwsList.add(new NameDesc(className, description));
    }

    public NameDesc getThrow(String name) {
        return JDMethodComment.getNameDesc(name, this.throwsList);
    }

    public void setParmsList(ArrayList<NameDesc> parmsList) {
        this.parmsList = parmsList;
    }

    public void setThrowsList(ArrayList<NameDesc> throwsList) {
        this.throwsList = throwsList;
    }
}

