/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class JDClassComment
extends JDComment {
    private ArrayList authorsList;
    private String version;

    public JDClassComment(CommentFormatter formatter) {
        super(formatter);
    }

    @Override
    protected void generateSpecial(String prefix, @NonNls StringBuffer sb) {
        if (!JDClassComment.isNull(this.authorsList)) {
            for (Object aAuthorsList : this.authorsList) {
                String s = (String)aAuthorsList;
                sb.append(prefix);
                sb.append("@author ");
                sb.append(this.myFormatter.getParser().splitIntoCLines(s, prefix + "        ", false));
            }
        }
        if (!JDClassComment.isNull(this.version)) {
            sb.append(prefix);
            sb.append("@version ");
            sb.append(this.myFormatter.getParser().splitIntoCLines(this.version, prefix + "         ", false));
        }
    }

    public void addAuthor(String author) {
        if (this.authorsList == null) {
            this.authorsList = new ArrayList();
        }
        this.authorsList.add(author);
    }

    public ArrayList getAuthorsList() {
        return this.authorsList;
    }

    public void setAuthorsList(ArrayList authorsList) {
        this.authorsList = authorsList;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

