/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.DummyHolderViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class DummyHolder
extends PsiFileImpl {
    protected final PsiElement myContext;
    private final CharTable myTable;
    private final Boolean myExplicitlyValid;
    private final Language myLanguage;
    private volatile FileElement myFileElement;
    private final Object myTreeElementLock;
    private FileViewProvider myViewProvider;

    public DummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        this(manager, contentElement, context, SharedImplUtil.findCharTableByTree(contentElement));
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table, boolean validity) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        this(manager, null, null, table, validity, FileTypes.PLAIN_TEXT.getLanguage());
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        this(manager, null, context, null);
    }

    public DummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        this(manager, contentElement, context, table, null, context == null ? FileTypes.PLAIN_TEXT.getLanguage() : context.getLanguage());
    }

    public DummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context, CharTable table, Boolean validity, Language language) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        super(TokenType.DUMMY_HOLDER, TokenType.DUMMY_HOLDER, new DummyHolderViewProvider(manager));
        this.myFileElement = null;
        this.myTreeElementLock = new String("DummyHolder's tree element lock");
        this.myViewProvider = null;
        ((DummyHolderViewProvider)this.getViewProvider()).setDummyHolder(this);
        this.myContext = context;
        Object object = this.myTable = table != null ? table : IdentityCharTable.INSTANCE;
        if (contentElement != null) {
            this.getTreeElement().rawAddChildren(contentElement);
            this.clearCaches();
        }
        this.myExplicitlyValid = validity;
        this.myLanguage = language;
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        this(manager, null, context, table);
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table, Language language) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.<init> must not be null");
        }
        this(manager, null, null, table, null, language);
    }

    public DummyHolder(PsiManager manager, Language language, PsiElement context) {
        this(manager, null, context, null, null, language);
    }

    @Override
    public PsiElement getContext() {
        return this.myContext;
    }

    @Override
    public boolean isValid() {
        if (this.myExplicitlyValid != null) {
            return this.myExplicitlyValid;
        }
        return super.isValid() && (this.myContext == null || this.myContext.isValid());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/DummyHolder.accept must not be null");
        }
        visitor.visitFile((PsiFile)this);
    }

    public String toString() {
        return "DummyHolder";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType;
        PsiFile containingFile;
        if (this.myContext != null && (containingFile = this.myContext.getContainingFile()) != null) {
            languageFileType = containingFile.getFileType();
            if (languageFileType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/DummyHolder.getFileType must not return null");
            return languageFileType;
        }
        languageFileType = StdFileTypes.JAVA;
        if (languageFileType != null) return languageFileType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/DummyHolder.getFileType must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileElement getTreeElement() {
        if (this.myFileElement != null) {
            return this.myFileElement;
        }
        Object object = this.myTreeElementLock;
        synchronized (object) {
            return this.getTreeElementNoLock();
        }
    }

    @Override
    public FileElement getTreeElementNoLock() {
        if (this.myFileElement == null) {
            this.myFileElement = new FileElement(TokenType.DUMMY_HOLDER, null);
            this.myFileElement.setPsi((PsiElement)this);
            if (this.myTable != null) {
                this.myFileElement.setCharTable(this.myTable);
            }
            this.clearCaches();
        }
        return this.myFileElement;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/DummyHolder.getLanguage must not return null");
        }
        return language;
    }

    @Override
    protected PsiFileImpl clone() {
        PsiFileImpl psiFile = this.cloneImpl(this.myFileElement);
        DummyHolderViewProvider dummyHolderViewProvider = new DummyHolderViewProvider(this.getManager());
        this.myViewProvider = dummyHolderViewProvider;
        dummyHolderViewProvider.setDummyHolder((DummyHolder)psiFile);
        FileElement treeClone = (FileElement)this.calcTreeElement().clone();
        psiFile.setTreeElementPointer(treeClone);
        psiFile.myOriginalFile = this.isPhysical() ? this : this.myOriginalFile;
        treeClone.setPsi((PsiElement)psiFile);
        return psiFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider;
        if (this.myViewProvider != null) {
            fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/DummyHolder.getViewProvider must not return null");
            return fileViewProvider;
        }
        fileViewProvider = super.getViewProvider();
        if (fileViewProvider != null) return fileViewProvider;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/DummyHolder.getViewProvider must not return null");
    }
}

