/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTypePointerManagerImpl
extends SmartTypePointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartTypePointerManagerImpl");
    private final SmartPointerManager myPsiPointerManager;
    private final Project myProject;

    public SmartTypePointerManagerImpl(SmartPointerManager psiPointerManager, Project project) {
        this.myPsiPointerManager = psiPointerManager;
        this.myProject = project;
    }

    @NotNull
    public SmartTypePointer createSmartTypePointer(PsiType type) {
        SmartTypePointer smartTypePointer = (SmartTypePointer)type.accept((PsiTypeVisitor)new SmartTypeCreatingVisitor());
        if (smartTypePointer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl.createSmartTypePointer must not return null");
        }
        return smartTypePointer;
    }

    private class SmartTypeCreatingVisitor
    extends PsiTypeVisitor<SmartTypePointer> {
        private SmartTypeCreatingVisitor() {
        }

        public SmartTypePointer visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return new SimpleTypePointer((PsiType)primitiveType);
        }

        public SmartTypePointer visitArrayType(PsiArrayType arrayType) {
            return new ArrayTypePointer((PsiType)arrayType, (SmartTypePointer)arrayType.getComponentType().accept((PsiTypeVisitor)this));
        }

        public SmartTypePointer visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            SmartTypePointer boundPointer = bound == null ? null : (SmartTypePointer)bound.accept((PsiTypeVisitor)this);
            return new WildcardTypePointer(wildcardType, boundPointer);
        }

        public SmartTypePointer visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                if (classType instanceof PsiClassReferenceType) {
                    return new ClassReferenceTypePointer((PsiClassReferenceType)classType);
                }
                return new SimpleTypePointer((PsiType)classType);
            }
            if (classType instanceof PsiClassReferenceType) {
                classType = ((PsiClassReferenceType)classType).createImmediateCopy();
            }
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            HashMap map = new HashMap();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType substitutionResult = substitutor.substitute(typeParameter);
                if (substitutionResult == null) continue;
                SmartPsiElementPointer pointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer((PsiElement)typeParameter);
                map.put((Object)pointer, substitutionResult.accept((PsiTypeVisitor)this));
            }
            return new ClassTypePointer((PsiType)classType, SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer((PsiElement)aClass), (Map<SmartPsiElementPointer, SmartTypePointer>)map);
        }
    }

    private class ClassReferenceTypePointer
    implements SmartTypePointer {
        private PsiType myType;
        private final SmartPsiElementPointer mySmartPsiElementPointer;
        private final String myReferenceText;

        ClassReferenceTypePointer(PsiClassReferenceType type) {
            this.myType = type;
            PsiJavaCodeReferenceElement reference = type.getReference();
            this.mySmartPsiElementPointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer((PsiElement)reference);
            this.myReferenceText = reference.getText();
        }

        public PsiType getType() {
            if (this.myType.isValid()) {
                return this.myType;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.mySmartPsiElementPointer.getElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)SmartTypePointerManagerImpl.this.myProject).getElementFactory();
            if (referenceElement != null) {
                this.myType = factory.createType(referenceElement);
            } else {
                try {
                    this.myType = factory.createTypeFromText(this.myReferenceText, null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return this.myType;
        }
    }

    private static class ClassTypePointer
    implements SmartTypePointer {
        private PsiType myType;
        private final SmartPsiElementPointer myClass;
        private final Map<SmartPsiElementPointer, SmartTypePointer> myMap;

        public ClassTypePointer(PsiType type, SmartPsiElementPointer aClass, Map<SmartPsiElementPointer, SmartTypePointer> map) {
            this.myType = type;
            this.myClass = aClass;
            this.myMap = map;
        }

        @Nullable
        public PsiType getType() {
            if (this.myType.isValid()) {
                return this.myType;
            }
            PsiElement classElement = this.myClass.getElement();
            if (!(classElement instanceof PsiClass)) {
                return null;
            }
            HashMap resurrected = new HashMap();
            Set<Map.Entry<SmartPsiElementPointer, SmartTypePointer>> set = this.myMap.entrySet();
            for (Map.Entry<SmartPsiElementPointer, SmartTypePointer> entry : set) {
                PsiElement element = entry.getKey().getElement();
                if (!(element instanceof PsiTypeParameter)) continue;
                resurrected.put((PsiTypeParameter)element, entry.getValue().getType());
            }
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiClass)classElement))) {
                if (resurrected.containsKey(typeParameter)) continue;
                resurrected.put(typeParameter, null);
            }
            PsiSubstitutor resurrectedSubstitutor = PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)resurrected);
            this.myType = new PsiImmediateClassType((PsiClass)classElement, resurrectedSubstitutor);
            return this.myType;
        }
    }

    private static class WildcardTypePointer
    implements SmartTypePointer {
        private final PsiWildcardType myType;
        private final PsiManager myManager;
        private final SmartTypePointer myBoundPointer;
        private final boolean myIsExtending;

        public WildcardTypePointer(PsiWildcardType type, SmartTypePointer boundPointer) {
            this.myType = type;
            this.myManager = this.myType.getManager();
            this.myBoundPointer = boundPointer;
            this.myIsExtending = this.myType.isExtends();
        }

        public PsiType getType() {
            if (this.myType.isValid()) {
                return this.myType;
            }
            if (this.myBoundPointer == null) {
                return PsiWildcardType.createUnbounded((PsiManager)this.myManager);
            }
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends((PsiManager)this.myManager, (PsiType)this.myBoundPointer.getType());
            }
            return PsiWildcardType.createSuper((PsiManager)this.myManager, (PsiType)this.myBoundPointer.getType());
        }
    }

    private static class ArrayTypePointer
    implements SmartTypePointer {
        private PsiType myType;
        private final SmartTypePointer myComponentTypePointer;

        public ArrayTypePointer(PsiType type, SmartTypePointer componentTypePointer) {
            this.myType = type;
            this.myComponentTypePointer = componentTypePointer;
        }

        public PsiType getType() {
            if (this.myType.isValid()) {
                return this.myType;
            }
            PsiType type = this.myComponentTypePointer.getType();
            this.myType = type == null ? null : new PsiArrayType(type);
            return this.myType;
        }
    }

    private static class SimpleTypePointer
    implements SmartTypePointer {
        private final PsiType myType;

        private SimpleTypePointer(PsiType type) {
            this.myType = type;
        }

        public PsiType getType() {
            return this.myType;
        }
    }
}

