/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.PsiModifierListImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsModifierListImpl
extends ClsRepositoryPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsModifierListImpl");

    public ClsModifierListImpl(PsiModifierListStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsModifierListImpl.getChildren must not return null");
        }
        return psiAnnotationArray;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.hasModifierProperty must not be null");
        }
        int flag = PsiModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name);
        assert (flag != 0);
        return (((PsiModifierListStub)this.getStub()).getModifiersMask() & flag) != 0;
    }

    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.hasExplicitModifier must not be null");
        }
        return this.hasModifierProperty(name);
    }

    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.setModifierProperty must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.checkSetModifierProperty must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])((PsiModifierListStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsModifierListImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsModifierListImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.addAnnotation must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    private boolean isAnnotationFormattingAllowed() {
        PsiElement element = this.getParent();
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        boolean isInterfaceClass;
        PsiAnnotation[] annotations = this.getAnnotations();
        boolean formattingAllowed = this.isAnnotationFormattingAllowed();
        for (PsiAnnotation annotation : annotations) {
            ((ClsAnnotationImpl)annotation).appendMirrorText(indentLevel, buffer);
            if (formattingAllowed) {
                ClsModifierListImpl.goNextLine(indentLevel, buffer);
                continue;
            }
            buffer.append(' ');
        }
        PsiElement parent = this.getParent();
        boolean isInterface = parent instanceof PsiClass && ((PsiClass)parent).isInterface();
        boolean isInterfaceMethod = parent instanceof PsiMethod && parent.getParent() instanceof PsiClass && ((PsiClass)parent.getParent()).isInterface();
        boolean isInterfaceField = parent instanceof PsiField && parent.getParent() instanceof PsiClass && ((PsiClass)parent.getParent()).isInterface();
        boolean bl = isInterfaceClass = parent instanceof PsiClass && parent.getParent() instanceof PsiClass && ((PsiClass)parent.getParent()).isInterface();
        if (this.hasModifierProperty("public") && !isInterfaceMethod && !isInterfaceField && !isInterfaceClass) {
            buffer.append("public");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("protected")) {
            buffer.append("protected");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("private")) {
            buffer.append("private");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("static") && !isInterfaceField) {
            buffer.append("static");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("abstract") && !isInterface && !isInterfaceMethod) {
            buffer.append("abstract");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("final") && !isInterfaceField) {
            buffer.append("final");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("native")) {
            buffer.append("native");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("synchronized")) {
            buffer.append("synchronized");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("transient")) {
            buffer.append("transient");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("volatile")) {
            buffer.append("volatile");
            buffer.append(' ');
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.MODIFIER_LIST);
        PsiAnnotation[] mirrorAnnotations = ((PsiModifierList)SourceTreeToPsiMap.treeElementToPsi(element)).getAnnotations();
        PsiAnnotation[] annotations = this.getAnnotations();
        LOG.assertTrue(annotations.length == mirrorAnnotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            ((ClsElementImpl)annotations[i]).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirrorAnnotations[i]));
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiModifierList";
    }
}

