/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    public boolean acceptsFile(VirtualFile file) {
        return !ClassFileStubBuilder.isInner(file.getNameWithoutExtension(), new ParentDirectory(file));
    }

    static boolean isInner(String name, Directory directory) {
        return ClassFileStubBuilder.isInner(name, 0, directory);
    }

    private static boolean isInner(String name, int from, Directory directory) {
        int index = name.indexOf(36, from);
        return index == -1 ? false : (ClassFileStubBuilder.containsPart(directory, name, index) ? true : ClassFileStubBuilder.isInner(name, index + 1, directory));
    }

    private static boolean containsPart(Directory directory, String name, int endIndex) {
        return endIndex > 0 && directory.contains(name.substring(0, endIndex));
    }

    public StubElement buildStubTree(VirtualFile file, byte[] content, Project project) {
        try {
            return ClsStubBuilder.build(file, content);
        }
        catch (ClsFormatException e) {
            return null;
        }
    }

    public int getStubVersion() {
        return 3;
    }

    private static class ParentDirectory
    implements Directory {
        private final VirtualFile myDirectory;
        private final String myExtension;

        private ParentDirectory(VirtualFile file) {
            this.myDirectory = file.getParent();
            this.myExtension = file.getExtension();
        }

        @Override
        public boolean contains(String name) {
            String fullName;
            String string = fullName = this.myExtension == null ? name : name + "." + this.myExtension;
            return this.myDirectory == null ? false : this.myDirectory.findChild(fullName) != null;
        }
    }

    static interface Directory {
        public boolean contains(String var1);
    }
}

