/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeCacheManager
implements CacheManager {
    private final List<CacheManager> myManagers = new ArrayList<CacheManager>();

    public void addCacheManager(CacheManager manager) {
        this.myManagers.add(manager);
    }

    @Override
    public void initialize() {
        for (CacheManager cacheManager : this.myManagers) {
            cacheManager.initialize();
        }
    }

    @Override
    public void dispose() {
        for (CacheManager cacheManager : this.myManagers) {
            cacheManager.dispose();
        }
    }

    @Override
    @NotNull
    public CacheUpdater[] getCacheUpdaters() {
        ArrayList<CacheUpdater> updaters = new ArrayList<CacheUpdater>();
        for (CacheManager cacheManager : this.myManagers) {
            updaters.addAll(Arrays.asList(cacheManager.getCacheUpdaters()));
        }
        CacheUpdater[] cacheUpdaterArray = updaters.toArray(new CacheUpdater[updaters.size()]);
        if (cacheUpdaterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/CompositeCacheManager.getCacheUpdaters must not return null");
        }
        return cacheUpdaterArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.getFilesWithWord must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.getFilesWithWord must not be null");
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processFilesWithWord((Processor<PsiFile>)processor, word, occurenceMask, scope, caseSensitively);
        PsiFile[] psiFileArray = processor.getResults().isEmpty() ? PsiFile.EMPTY_ARRAY : (PsiFile[])processor.toArray((Object[])new PsiFile[processor.getResults().size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/CompositeCacheManager.getFilesWithWord must not return null");
        }
        return psiFileArray;
    }

    @Override
    public boolean processFilesWithWord(@NotNull Processor<PsiFile> processor, @NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.processFilesWithWord must not be null");
        }
        if (word == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.processFilesWithWord must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.processFilesWithWord must not be null");
        }
        for (CacheManager cacheManager : this.myManagers) {
            if (cacheManager.processFilesWithWord(processor, word, occurenceMask, scope, caseSensitively)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithTodoItems() {
        ArrayList<PsiFile> files = null;
        for (CacheManager cacheManager : this.myManagers) {
            PsiFile[] items = cacheManager.getFilesWithTodoItems();
            if (items.length == 0 || files != null) continue;
            files = new ArrayList<PsiFile>();
            files.addAll(Arrays.asList(items));
        }
        PsiFile[] psiFileArray = files == null ? PsiFile.EMPTY_ARRAY : files.toArray(new PsiFile[files.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/CompositeCacheManager.getFilesWithTodoItems must not return null");
        }
        return psiFileArray;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file, IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.getTodoCount must not be null");
        }
        int count = 0;
        for (CacheManager cacheManager : this.myManagers) {
            int todoCount = cacheManager.getTodoCount(file, patternProvider);
            if (todoCount == -1) {
                return -1;
            }
            count += todoCount;
        }
        return count;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file, IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.getTodoCount must not be null");
        }
        int count = 0;
        for (CacheManager cacheManager : this.myManagers) {
            int todoCount = cacheManager.getTodoCount(file, pattern);
            if (todoCount == -1) {
                return -1;
            }
            count += todoCount;
        }
        return count;
    }

    @Override
    public void addOrInvalidateFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/impl/CompositeCacheManager.addOrInvalidateFile must not be null");
        }
        for (CacheManager cacheManager : this.myManagers) {
            cacheManager.addOrInvalidateFile(file);
        }
    }
}

