/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final List<PsiShortNamesCache> myCaches = new ArrayList<PsiShortNamesCache>();
    private PsiShortNamesCache[] myCacheArray = new PsiShortNamesCache[0];

    public void addCache(PsiShortNamesCache cache) {
        this.myCaches.add(cache);
        this.myCacheArray = this.myCaches.toArray(new PsiShortNamesCache[this.myCaches.size()]);
    }

    public void runStartupActivity() {
        for (PsiShortNamesCache cache : this.myCaches) {
            cache.runStartupActivity();
        }
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getFilesByName must not be null");
        }
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.myCacheArray) {
            PsiFile[] classes = cache.getFilesByName(name);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes);
        }
        PsiFile[] result = merger == null ? null : (PsiFile[])merger.getResult();
        PsiFile[] psiFileArray = result != null ? result : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getFilesByName must not return null");
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCacheArray) {
            merger.add(cache.getAllFileNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getAllFileNames must not return null");
        }
        return stringArray;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getClassesByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getClassesByName must not be null");
        }
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.myCacheArray) {
            PsiClass[] classes = cache.getClassesByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes);
        }
        PsiClass[] result = merger == null ? null : (PsiClass[])merger.getResult();
        PsiClass[] psiClassArray = result != null ? result : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getClassesByName must not return null");
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCacheArray) {
            merger.add(cache.getAllClassNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getAllClassNames must not return null");
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getAllClassNames must not be null");
        }
        for (PsiShortNamesCache cache : this.myCacheArray) {
            cache.getAllClassNames(dest);
        }
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getMethodsByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getMethodsByName must not be null");
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCacheArray) {
            PsiMethod[] classes = cache.getMethodsByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(classes);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result != null ? result : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getMethodsByNameIfNotMoreThan must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getMethodsByNameIfNotMoreThan must not be null");
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCacheArray) {
            PsiMethod[] classes = cache.getMethodsByNameIfNotMoreThan(name, scope, maxCount);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(classes);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result != null ? result : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getMethodsByNameIfNotMoreThan must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCacheArray) {
            merger.add(cache.getAllMethodNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getAllMethodNames must not return null");
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getAllMethodNames must not be null");
        }
        for (PsiShortNamesCache cache : this.myCacheArray) {
            cache.getAllMethodNames(set);
        }
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getFieldsByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getFieldsByName must not be null");
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCacheArray) {
            PsiField[] classes = cache.getFieldsByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result != null ? result : PsiField.EMPTY_ARRAY;
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getFieldsByName must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCacheArray) {
            merger.add(cache.getAllFieldNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/CompositeShortNamesCache.getAllFieldNames must not return null");
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/CompositeShortNamesCache.getAllFieldNames must not be null");
        }
        for (PsiShortNamesCache cache : this.myCacheArray) {
            cache.getAllFieldNames(set);
        }
    }

    public String toString() {
        return "Composite cache: " + this.myCaches;
    }

    private static class Merger<T> {
        private T[] mySingleItem = null;
        private Set<T> myAllItems = null;

        private Merger() {
        }

        public void add(T[] items) {
            if (items == null || items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                this.myAllItems = new THashSet(Arrays.asList(this.mySingleItem));
            }
            this.myAllItems.addAll(Arrays.asList(items));
        }

        public T[] getResult() {
            if (this.myAllItems == null) {
                return this.mySingleItem;
            }
            return this.myAllItems.toArray(this.mySingleItem);
        }
    }
}

