/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.WrapType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;

public class XmlPolicy
extends XmlFormattingPolicy {
    private final CodeStyleSettings mySettings;

    public XmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
        super(documentModel);
        this.mySettings = settings;
    }

    @Override
    public boolean indentChildrenOf(XmlTag parentTag) {
        return !(parentTag.getFirstChild() instanceof PsiErrorElement);
    }

    @Override
    public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
        return false;
    }

    @Override
    public boolean removeLineBreakBeforeTag(XmlTag xmlTag) {
        return false;
    }

    @Override
    public WrapType getWrappingTypeForTagEnd(XmlTag xmlTag) {
        return xmlTag.getSubTags().length > 0 ? WrapType.ALWAYS : WrapType.NORMAL;
    }

    @Override
    public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
        PsiElement element = tag.getNextSibling();
        if (element instanceof XmlText && !(element.getFirstChild() instanceof PsiWhiteSpace) && tag.getSubTags().length == 0) {
            return WrapType.NORMAL;
        }
        return WrapType.ALWAYS;
    }

    @Override
    public boolean isTextElement(XmlTag tag) {
        return false;
    }

    @Override
    public boolean keepWhiteSpacesInsideTag(XmlTag tag) {
        return false;
    }

    @Override
    public int getTextWrap(XmlTag tag) {
        return this.mySettings.XML_TEXT_WRAP;
    }

    @Override
    public int getAttributesWrap() {
        return this.mySettings.XML_ATTRIBUTE_WRAP;
    }

    @Override
    public boolean getShouldAlignAttributes() {
        return this.mySettings.XML_ALIGN_ATTRIBUTES;
    }

    @Override
    public boolean getShouldAlignText() {
        return this.mySettings.XML_ALIGN_TEXT;
    }

    @Override
    public boolean getShouldKeepWhiteSpaces() {
        return this.mySettings.XML_KEEP_WHITESPACES;
    }

    @Override
    public boolean getShouldAddSpaceAroundEqualityInAttribute() {
        return this.mySettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE;
    }

    @Override
    public boolean getShouldAddSpaceAroundTagName() {
        return this.mySettings.XML_SPACE_AFTER_TAG_NAME;
    }

    @Override
    public int getKeepBlankLines() {
        return this.mySettings.XML_KEEP_BLANK_LINES;
    }

    @Override
    public boolean getShouldKeepLineBreaks() {
        return this.mySettings.XML_KEEP_LINE_BREAKS;
    }

    @Override
    public boolean getShouldKeepLineBreaksInText() {
        return this.mySettings.XML_KEEP_LINE_BREAKS_IN_TEXT;
    }

    @Override
    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public boolean addSpaceIntoEmptyTag() {
        return this.mySettings.XML_SPACE_INSIDE_EMPTY_TAG;
    }

    @Override
    public boolean shouldSaveSpacesBetweenTagAndText() {
        return false;
    }
}

