/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageFileAction
extends AnAction {
    public PackageFileAction() {
        super(CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]), CompilerBundle.message((String)"action.description.package.file", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent e) {
        List<VirtualFile> files;
        boolean visible = false;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project != null && !(files = PackageFileAction.getFilesToPackage(e, project)).isEmpty()) {
            visible = true;
            e.getPresentation().setText(files.size() == 1 ? CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]) : CompilerBundle.message((String)"action.name.package.files", (Object[])new Object[0]));
        }
        e.getPresentation().setVisible(visible);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<VirtualFile> getFilesToPackage(@NotNull AnActionEvent e, @NotNull Project project) {
        List<Object> list;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/ui/actions/PackageFileAction.getFilesToPackage must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/ui/actions/PackageFileAction.getFilesToPackage must not be null");
        }
        VirtualFile[] files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/ui/actions/PackageFileAction.getFilesToPackage must not return null");
            return list;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        block0: for (VirtualFile file : files) {
            if (file == null || file.isDirectory() || fileIndex.isInSourceContent(file) && compilerManager.isCompilableFileType(file.getFileType())) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/ui/actions/PackageFileAction.getFilesToPackage must not return null");
                return list;
            }
            Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project).findArtifacts(file);
            for (Artifact artifact : artifacts) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result.add(file);
                continue block0;
            }
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/ui/actions/PackageFileAction.getFilesToPackage must not return null");
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files = PackageFileAction.getFilesToPackage(event, project);
        try {
            for (VirtualFile file : files) {
                PackageFileWorker.packageFile(file, project);
            }
            PackageFileAction.setStatusText(project, files);
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)CompilerBundle.message((String)"message.tect.package.file.io.error", (Object[])new Object[]{e}), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void setStatusText(Project project, List<VirtualFile> files) {
        if (!files.isEmpty()) {
            String fileNames = "";
            for (VirtualFile file : files) {
                if (fileNames.length() != 0) {
                    fileNames = fileNames + ", ";
                }
                fileNames = fileNames + "'" + file.getName() + "'";
            }
            String time = DateFormat.getTimeInstance().format(new Date());
            String statusText = CompilerBundle.message((String)"status.text.file.has.been.packaged", (Object[])new Object[]{files.size(), fileNames, time});
            WindowManager.getInstance().getStatusBar(project).setInfo(statusText);
        }
    }
}

