/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.ContentManagerEvent;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.border.EmptyBorder;

abstract class ContentLayout {
    static final Color TAB_BORDER_ACTIVE_WINDOW = new Color(38, 63, 106);
    static final Color TAB_BORDER_PASSIVE_WINDOW = new Color(130, 120, 111);
    static final Color TAB_BG_ACTIVE_WND_SELECTED_FROM = new Color(90, 133, 215);
    static final Color TAB_BG_ACTIVE_WND_SELECTED_TO = new Color(33, 87, 138);
    static final Color TAB_BG_ACTIVE_WND_UNSELECTED_FROM = new Color(129, 147, 219);
    static final Color TAB_BG_ACTIVE_WND_UNSELECTED_TO = new Color(84, 130, 171);
    static final Color TAB_BG_PASSIVE_WND_FROM = new Color(152, 143, 134);
    static final Color TAB_BG_PASSIVE_WND_TO = new Color(165, 157, 149);
    static final int TAB_ARC = 2;
    static final int TAB_SHIFT = 3;
    ToolWindowContentUi myUi;

    ContentLayout(ToolWindowContentUi ui) {
        this.myUi = ui;
    }

    public abstract void init();

    public abstract void reset();

    public abstract void layout();

    public abstract void paintComponent(Graphics var1);

    public abstract void paintChildren(Graphics var1);

    public abstract void update();

    public abstract void rebuild();

    public abstract void contentAdded(ContentManagerEvent var1);

    public abstract void contentRemoved(ContentManagerEvent var1);

    protected void updateIdLabel(BaseLabel label) {
        String text;
        label.setText(this.myUi.myWindow.getId());
        label.setBorder(new EmptyBorder(0, 2, 0, 8));
        if (this.myUi.myManager.getContentCount() == 1 && (text = this.myUi.myManager.getContent(0).getDisplayName()) != null && text.trim().length() > 0) {
            label.setText(label.getText() + " ");
            label.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
    }

    protected void fillTabShape(Graphics2D g2d, BaseLabel each, Shape shape, boolean isSelected) {
        Rectangle bounds = each.getBounds();
        if (this.myUi.myWindow.isActive()) {
            if (isSelected) {
                g2d.setPaint(new GradientPaint(bounds.x, bounds.y, TAB_BG_ACTIVE_WND_SELECTED_FROM, bounds.x, (float)bounds.getMaxY(), TAB_BG_ACTIVE_WND_SELECTED_TO));
            } else {
                g2d.setPaint(new GradientPaint(bounds.x, bounds.y, TAB_BG_ACTIVE_WND_UNSELECTED_FROM, bounds.x, (float)bounds.getMaxY(), TAB_BG_ACTIVE_WND_UNSELECTED_TO));
            }
        } else {
            g2d.setPaint(new GradientPaint(bounds.x, bounds.y, TAB_BG_PASSIVE_WND_FROM, bounds.x, (float)bounds.getMaxY(), TAB_BG_PASSIVE_WND_TO));
        }
        g2d.fill(shape);
    }

    public abstract void showContentPopup(ListPopup var1);
}

